/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.StringUtils;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.sql.SQL;

public class DeleteSQLBuilder {
    private final Table table;
    private final Dialect dialect;
    private final JDBCWhereParser whereParser;
    private final JDBCOrderByParser orderByParser;

    public DeleteSQLBuilder(Table table, Dialect dialect, JDBCWhereParser whereParser, JDBCOrderByParser orderByParser) {
        this.table = table;
        this.dialect = dialect;
        this.whereParser = whereParser;
        this.orderByParser = orderByParser;
    }

    public SQL buildDeleteSQL(Query query) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBys());
        String sql = this.GetDeleteSQL(whereClause.expression(), orderByClauses, query.getLimit());
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    public String GetDeleteSQL(String whereClause, String[] orderByClauses, Long limit) {
        if (whereClause == null || whereClause.isEmpty()) {
            throw new IllegalArgumentException("\u5220\u9664\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        String sql = "DELETE FROM " + this.getTableName() + this.getWhereClause(whereClause) + this.getOrderByClause(orderByClauses);
        return this.dialect.applyLimit(sql, null, limit);
    }

    private String getTableName() {
        return this.dialect.quoteIdentifier(this.table.name());
    }

    private String getWhereClause(String whereClause) {
        return StringUtils.notEmpty((String)whereClause) ? " WHERE " + whereClause : "";
    }

    private String getOrderByClause(String[] orderByClauses) {
        return orderByClauses != null && orderByClauses.length != 0 ? " ORDER BY " + String.join((CharSequence)", ", orderByClauses) : "";
    }
}

