/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.ArrayUtils;
import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.mapping.EntityColumn;
import cool.scx.data.jdbc.mapping.EntityTable;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.jdbc.sql_builder.SQLBuilderHelper;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.sql.SQL;
import java.util.ArrayList;
import java.util.Collection;

public class InsertSQLBuilder {
    private final EntityTable<?> table;
    private final Dialect dialect;
    private final JDBCColumnNameParser columnNameParser;

    public InsertSQLBuilder(EntityTable<?> table, Dialect dialect, JDBCColumnNameParser columnNameParser) {
        this.table = table;
        this.dialect = dialect;
        this.columnNameParser = columnNameParser;
    }

    public static String[] createInsertExpressionsColumns(FieldPolicy fieldPolicy, JDBCColumnNameParser parser) {
        AssignField[] assignFields = fieldPolicy.getAssignFields();
        String[] result = new String[assignFields.length];
        int i = 0;
        for (AssignField fieldExpression : assignFields) {
            result[i] = parser.parseColumnName(fieldExpression.fieldName(), false);
            ++i;
        }
        return result;
    }

    public static String[] createInsertValues(Column[] columns) {
        String[] result = new String[columns.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = "?";
        }
        return result;
    }

    public static String[] createInsertExpressionsValue(FieldPolicy fieldPolicy) {
        AssignField[] assignFields = fieldPolicy.getAssignFields();
        String[] result = new String[assignFields.length];
        int i = 0;
        for (AssignField fieldExpression : assignFields) {
            result[i] = fieldExpression.expression();
            ++i;
        }
        return result;
    }

    public SQL buildInsertSQL(Object entity, FieldPolicy fieldPolicy) {
        Column[] insertColumns = SQLBuilderHelper.filterByUpdateFieldPolicy(fieldPolicy, this.table, entity);
        String[] insertExpressionsColumns = InsertSQLBuilder.createInsertExpressionsColumns(fieldPolicy, this.columnNameParser);
        String[] insertValues = InsertSQLBuilder.createInsertValues(insertColumns);
        String[] insertExpressionsValue = InsertSQLBuilder.createInsertExpressionsValue(fieldPolicy);
        Object[] finalInsertColumns = ArrayUtils.concat((Object[][])new Object[][]{insertColumns, insertExpressionsColumns});
        String[] finalInsertValues = (String[])ArrayUtils.concat((Object[][])new String[][]{insertValues, insertExpressionsValue});
        String sql = this.GetInsertSQL(finalInsertColumns, finalInsertValues);
        Object[] params = SQLBuilderHelper.extractValues((EntityColumn[])insertColumns, entity);
        return SQL.sql((String)sql, (Object[])params);
    }

    public SQL buildInsertBatchSQL(Collection<?> entityList, FieldPolicy fieldPolicy) {
        Column[] insertColumns = SQLBuilderHelper.filterByUpdateFieldPolicy(fieldPolicy, this.table);
        String[] insertExpressionsColumns = InsertSQLBuilder.createInsertExpressionsColumns(fieldPolicy, this.columnNameParser);
        String[] insertValues = InsertSQLBuilder.createInsertValues(insertColumns);
        String[] insertExpressionsValue = InsertSQLBuilder.createInsertExpressionsValue(fieldPolicy);
        Object[] finalInsertColumns = ArrayUtils.concat((Object[][])new Object[][]{insertColumns, insertExpressionsColumns});
        String[] finalInsertValues = (String[])ArrayUtils.concat((Object[][])new String[][]{insertValues, insertExpressionsValue});
        String sql = this.GetInsertSQL(finalInsertColumns, finalInsertValues);
        ArrayList<Object[]> batchParams = new ArrayList<Object[]>(entityList.size());
        for (Object entity : entityList) {
            batchParams.add(SQLBuilderHelper.extractValues((EntityColumn[])insertColumns, entity));
        }
        return SQL.sql((String)sql, batchParams);
    }

    private String GetInsertSQL(Object[] insertColumns, String[] insertValues) {
        return "INSERT INTO " + this.getTableName() + " (" + this.getInsertColumns(insertColumns) + ") VALUES (" + String.join((CharSequence)", ", insertValues) + ")";
    }

    private String getTableName() {
        return this.dialect.quoteIdentifier(this.table.name());
    }

    private String getInsertColumns(Object[] insertColumns) {
        return SQLBuilderHelper.joinWithQuoteIdentifier(insertColumns, this.dialect);
    }
}

