/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.data.exception.DataAccessException;
import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FilterMode;
import cool.scx.data.field_policy.VirtualField;
import cool.scx.data.jdbc.mapping.EntityColumn;
import cool.scx.data.jdbc.mapping.EntityTable;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;
import cool.scx.reflect.FieldInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

class SQLBuilderHelper {
    SQLBuilderHelper() {
    }

    public static EntityColumn[] filterByUpdateFieldPolicy(FieldPolicy fieldPolicy, EntityTable<?> table, Object entity) {
        EntityColumn[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        AssignField[] assignFields = fieldPolicy.getAssignFields();
        columns = SQLBuilderHelper.filterByAssignFields(assignFields, table, columns);
        boolean globalIgnoreNull = fieldPolicy.getIgnoreNull();
        Map ignoreNulls = fieldPolicy.getIgnoreNulls();
        return SQLBuilderHelper.filterByFieldValueIsNull(entity, globalIgnoreNull, ignoreNulls, columns);
    }

    public static EntityColumn[] filterByUpdateFieldPolicy(FieldPolicy fieldPolicy, EntityTable<?> table) {
        EntityColumn[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        AssignField[] assignFields = fieldPolicy.getAssignFields();
        return SQLBuilderHelper.filterByAssignFields(assignFields, table, columns);
    }

    public static Column[] filterByQueryFieldPolicy(FieldPolicy fieldPolicy, EntityTable<?> table) {
        Column[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        VirtualField[] virtualFields = fieldPolicy.getVirtualFields();
        return SQLBuilderHelper.filterByVirtualFields(virtualFields, table, columns);
    }

    public static Column[] filterByVirtualFields(VirtualField[] virtualFields, Table table, Column ... columns) {
        if (virtualFields.length == 0) {
            return columns;
        }
        ArrayList result = new ArrayList();
        Collections.addAll(result, columns);
        for (VirtualField fieldName : virtualFields) {
            result.remove(table.getColumn(fieldName.virtualFieldName()));
        }
        return (Column[])result.toArray(Column[]::new);
    }

    public static EntityColumn[] filterByFilterMode(FieldPolicy fieldPolicy, EntityTable<?> table) {
        FilterMode filterMode = fieldPolicy.getFilterMode();
        return switch (filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> SQLBuilderHelper.filterByIncluded(fieldPolicy.getFieldNames(), table);
            case FilterMode.EXCLUDED -> SQLBuilderHelper.filterByExcluded(fieldPolicy.getFieldNames(), table);
        };
    }

    public static EntityColumn[] filterByIncluded(String[] fieldNames, EntityTable<?> table) {
        if (fieldNames.length == 0) {
            return new EntityColumn[0];
        }
        ArrayList<EntityColumn> columns = new ArrayList<EntityColumn>();
        for (String fieldName : fieldNames) {
            EntityColumn column = table.getColumn(fieldName);
            if (column == null) continue;
            columns.add(column);
        }
        return (EntityColumn[])columns.toArray(EntityColumn[]::new);
    }

    public static EntityColumn[] filterByExcluded(String[] fieldNames, EntityTable<?> table) {
        if (fieldNames.length == 0) {
            return table.columns();
        }
        ArrayList allColumns = new ArrayList();
        Collections.addAll(allColumns, table.columns());
        for (String fieldName : fieldNames) {
            allColumns.remove(table.getColumn(fieldName));
        }
        return (EntityColumn[])allColumns.toArray(EntityColumn[]::new);
    }

    private static EntityColumn[] filterByFieldValueIsNull(Object entity, boolean globalIgnoreNull, Map<String, Boolean> ignoreNulls, EntityColumn ... columns) {
        if (entity == null && globalIgnoreNull && ignoreNulls.isEmpty()) {
            return new EntityColumn[0];
        }
        if (!globalIgnoreNull && ignoreNulls.isEmpty()) {
            return columns;
        }
        ArrayList<EntityColumn> result = new ArrayList<EntityColumn>();
        for (EntityColumn column : columns) {
            Object value;
            String fieldName = column.javaField().name();
            Boolean ignoreNull = ignoreNulls.getOrDefault(fieldName, globalIgnoreNull);
            Object object = value = entity != null ? SQLBuilderHelper.getJavaFieldValue(column.javaField(), entity) : null;
            if (ignoreNull.booleanValue() && value == null) continue;
            result.add(column);
        }
        return (EntityColumn[])result.toArray(EntityColumn[]::new);
    }

    public static EntityColumn[] filterByAssignFields(AssignField[] assignFields, EntityTable<?> table, EntityColumn ... columns) {
        if (assignFields.length == 0) {
            return columns;
        }
        ArrayList result = new ArrayList();
        Collections.addAll(result, columns);
        for (AssignField fieldName : assignFields) {
            result.remove(table.getColumn(fieldName.fieldName()));
        }
        return (EntityColumn[])result.toArray(EntityColumn[]::new);
    }

    public static Object[] extractValues(EntityColumn[] column, Object entity) {
        Object[] result = new Object[column.length];
        if (entity == null) {
            return result;
        }
        for (int i = 0; i < column.length; ++i) {
            result[i] = SQLBuilderHelper.getJavaFieldValue(column[i].javaField(), entity);
        }
        return result;
    }

    public static String joinWithQuoteIdentifier(Object[] values, Dialect dialect) {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            if (value instanceof Column) {
                Column c = (Column)value;
                sb.append(dialect.quoteIdentifier(c.name()));
                continue;
            }
            sb.append(value.toString());
        }
        return sb.toString();
    }

    public static Object getJavaFieldValue(FieldInfo field, Object entity) {
        try {
            return field.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new DataAccessException("\u8bfb\u53d6 Entity \u5b57\u6bb5\u503c\u65f6\u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
        }
    }
}

