/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.mysql_x;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class FieldFilter {
    private final Set<String> fieldNames = new HashSet<String>();
    private final FilterMode filterMode;
    private final boolean excludeIfFieldValueIsNull;

    private FieldFilter(FilterMode filterMode, boolean excludeIfFieldValueIsNull) {
        this.filterMode = filterMode;
        this.excludeIfFieldValueIsNull = excludeIfFieldValueIsNull;
    }

    public static FieldFilter ofIncluded() {
        return FieldFilter.ofIncluded(true);
    }

    public static FieldFilter ofIncluded(boolean excludeIfFieldValueIsNull) {
        return new FieldFilter(FilterMode.INCLUDED, excludeIfFieldValueIsNull);
    }

    public static FieldFilter ofIncluded(String ... fieldNames) {
        return FieldFilter.ofIncluded().addIncluded(fieldNames);
    }

    public static FieldFilter ofIncluded(boolean excludeIfFieldValueIsNull, String ... fieldNames) {
        return FieldFilter.ofIncluded(excludeIfFieldValueIsNull).addIncluded(fieldNames);
    }

    public static FieldFilter ofExcluded() {
        return FieldFilter.ofExcluded(true);
    }

    public static FieldFilter ofExcluded(boolean excludeIfFieldValueIsNull) {
        return new FieldFilter(FilterMode.EXCLUDED, excludeIfFieldValueIsNull);
    }

    public static FieldFilter ofExcluded(String ... fieldNames) {
        return FieldFilter.ofExcluded().addExcluded(fieldNames);
    }

    public static FieldFilter ofExcluded(boolean excludeIfFieldValueIsNull, String ... fieldNames) {
        return FieldFilter.ofExcluded(excludeIfFieldValueIsNull).addExcluded(fieldNames);
    }

    private FieldFilter _addFieldNames(String ... fieldNames) {
        this.fieldNames.addAll(Arrays.asList(fieldNames));
        return this;
    }

    private FieldFilter _removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this;
    }

    public FieldFilter addIncluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.INCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public FieldFilter addExcluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.EXCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public FieldFilter removeIncluded(String ... fieldNames) {
        return this.addExcluded(fieldNames);
    }

    public FieldFilter removeExcluded(String ... fieldNames) {
        return this.addIncluded(fieldNames);
    }

    public FieldFilter clear() {
        this.fieldNames.clear();
        return this;
    }

    public FilterMode filterMode() {
        return this.filterMode;
    }

    public Set<String> fieldNames() {
        return this.fieldNames;
    }

    public boolean excludeIfFieldValueIsNull() {
        return this.excludeIfFieldValueIsNull;
    }

    public static enum FilterMode {
        INCLUDED,
        EXCLUDED;


        public static FilterMode of(String filterModeStr) {
            return FilterMode.valueOf(filterModeStr.trim().toUpperCase());
        }
    }
}

