/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.mysql_x.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import cool.scx.data.query.exception.ValidParamListIsEmptyException;
import cool.scx.data.query.parser.WhereParser;
import cool.scx.util.ArrayUtils;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.util.Arrays;
import java.util.Objects;

public class MySQLXDaoWhereParser
extends WhereParser {
    public static final MySQLXDaoWhereParser WHERE_PARSER = new MySQLXDaoWhereParser();

    public WhereClause parseIsNull(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams = new Object[]{};
        String whereClause = name + " " + this.getWhereKeyWord(whereType);
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseEqual(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams = new Object[]{value1};
        String whereClause = name + " " + this.getWhereKeyWord(whereType) + " ?";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseLike(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams = new Object[]{value1};
        String whereClause = name + " " + this.getWhereKeyWord(whereType) + " '%?%'";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseIn(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams = Arrays.stream(ArrayUtils.toObjectArray((Object)value1)).filter(Objects::nonNull).distinct().toArray();
        if (whereParams.length == 0) {
            throw new ValidParamListIsEmptyException(whereType);
        }
        String v1 = "(" + StringUtils.repeat((String)"?", (String)", ", (int)whereParams.length) + ")";
        String whereClause = name + " " + this.getWhereKeyWord(whereType) + " " + v1;
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseBetween(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams = new Object[]{value1, value2};
        String whereClause = name + " " + this.getWhereKeyWord(whereType) + " ? AND ?";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseJsonContains(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams;
        String v1 = "?";
        if (info.useOriginalValue()) {
            whereParams = new Object[]{value1};
        } else {
            try {
                whereParams = new Object[]{ObjectUtils.toJson((Object)value1, (ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE, ObjectUtils.Option.IGNORE_NULL_VALUE})};
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5(\u65e0\u6cd5\u6b63\u786e\u8f6c\u6362\u4e3a JSON) !!! \u5b57\u6bb5\u540d : " + name, e);
            }
        }
        String whereClause = this.getWhereKeyWord(whereType) + "(" + name;
        whereClause = whereClause + ", " + v1 + ")";
        return new WhereClause(whereClause, whereParams);
    }
}

