/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.mysql_x;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DbDocImpl;
import com.mysql.cj.xdevapi.JsonArray;
import com.mysql.cj.xdevapi.JsonLiteral;
import com.mysql.cj.xdevapi.JsonNumber;
import com.mysql.cj.xdevapi.JsonString;
import com.mysql.cj.xdevapi.JsonValue;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.FieldFilter;
import cool.scx.data.field_filter.FilterMode;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;

class JsonHelper {
    static final ObjectMapper OBJECT_MAPPER = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE});
    final ObjectReader objectReader;

    JsonHelper(Class<?> c) {
        this.objectReader = OBJECT_MAPPER.readerFor(c);
    }

    public static JsonValue toJsonValue(JsonNode jsonNode) {
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            DbDocImpl dbDoc = new DbDocImpl();
            Iterator fields = objectNode.fields();
            while (fields.hasNext()) {
                Map.Entry next = (Map.Entry)fields.next();
                dbDoc.add((String)next.getKey(), JsonHelper.toJsonValue((JsonNode)next.getValue()));
            }
            return dbDoc;
        }
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            JsonArray jsonValue = new JsonArray();
            for (JsonNode node : arrayNode) {
                jsonValue.add((Object)JsonHelper.toJsonValue(node));
            }
            return jsonValue;
        }
        if (jsonNode instanceof NumericNode) {
            NumericNode numericNode = (NumericNode)jsonNode;
            return new JsonNumber().setValue(numericNode.asText());
        }
        if (jsonNode instanceof TextNode) {
            TextNode textNode = (TextNode)jsonNode;
            return new JsonString().setValue(textNode.asText());
        }
        if (jsonNode instanceof NullNode) {
            NullNode nullNode = (NullNode)jsonNode;
            return JsonLiteral.NULL;
        }
        if (jsonNode instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)jsonNode;
            boolean aBoolean = booleanNode.asBoolean();
            return aBoolean ? JsonLiteral.TRUE : JsonLiteral.FALSE;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684 jsonNode \u7c7b\u578b !!!");
    }

    public static ObjectNode filterObjectNode(ObjectNode objectNode, FieldFilter filter) {
        return switch (filter.getFilterMode()) {
            default -> throw new MatchException(null, null);
            case FilterMode.EXCLUDED -> {
                for (String s : filter.getFieldNames()) {
                    objectNode.remove(s);
                }
                yield objectNode;
            }
            case FilterMode.INCLUDED -> {
                ObjectNode newObjectNode = OBJECT_MAPPER.createObjectNode();
                for (String s : filter.getFieldNames()) {
                    newObjectNode.set(s, objectNode.get(s));
                }
                yield newObjectNode;
            }
        };
    }

    public static DbDoc filterDbDoc(DbDoc dbDoc, FieldFilter filter) {
        return switch (filter.getFilterMode()) {
            default -> throw new MatchException(null, null);
            case FilterMode.EXCLUDED -> {
                for (String s : filter.getFieldNames()) {
                    dbDoc.remove((Object)s);
                }
                yield dbDoc;
            }
            case FilterMode.INCLUDED -> {
                DbDocImpl newDbDoc = new DbDocImpl();
                for (String s : filter.getFieldNames()) {
                    newDbDoc.put((Object)s, (Object)((JsonValue)dbDoc.get((Object)s)));
                }
                yield newDbDoc;
            }
        };
    }

    public static JsonNode toObjectNode(JsonValue jsonValue) {
        if (jsonValue instanceof DbDoc) {
            DbDoc dbDoc = (DbDoc)jsonValue;
            ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
            dbDoc.forEach((key, value) -> objectNode.set(key, JsonHelper.toObjectNode(value)));
            return objectNode;
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
            for (JsonValue node : jsonArray) {
                arrayNode.add(JsonHelper.toObjectNode(node));
            }
            return arrayNode;
        }
        if (jsonValue instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)jsonValue;
            return DecimalNode.valueOf((BigDecimal)jsonNumber.getBigDecimal());
        }
        if (jsonValue instanceof JsonString) {
            JsonString jsonString = (JsonString)jsonValue;
            return TextNode.valueOf((String)jsonString.getString());
        }
        if (jsonValue instanceof JsonLiteral) {
            JsonLiteral jsonLiteral = (JsonLiteral)jsonValue;
            return switch (jsonLiteral) {
                default -> throw new MatchException(null, null);
                case JsonLiteral.NULL -> NullNode.getInstance();
                case JsonLiteral.TRUE -> BooleanNode.TRUE;
                case JsonLiteral.FALSE -> BooleanNode.FALSE;
            };
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684 jsonValue \u7c7b\u578b !!!");
    }
}

