/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.mysql_x;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mysql.cj.xdevapi.AddResult;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DocResult;
import com.mysql.cj.xdevapi.FindStatement;
import com.mysql.cj.xdevapi.JsonValue;
import com.mysql.cj.xdevapi.ModifyStatement;
import com.mysql.cj.xdevapi.RemoveStatement;
import com.mysql.cj.xdevapi.Result;
import com.mysql.cj.xdevapi.Schema;
import cool.scx.common.field_filter.FieldFilter;
import cool.scx.common.util.CaseUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.Dao;
import cool.scx.data.Query;
import cool.scx.data.mysql_x.JsonHelper;
import cool.scx.data.mysql_x.annotation.Collection;
import cool.scx.data.mysql_x.parser.MySQLXDaoWhereParser;
import cool.scx.data.query.WhereClause;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class MySQLXDao<Entity>
implements Dao<Entity, String> {
    private final com.mysql.cj.xdevapi.Collection collection;
    private final Class<Entity> entityClass;
    private final JsonHelper jsonHelper;

    public MySQLXDao(Class<Entity> entityClass, com.mysql.cj.xdevapi.Collection collection) {
        this.entityClass = entityClass;
        this.collection = collection;
        this.jsonHelper = new JsonHelper(entityClass);
    }

    public MySQLXDao(Class<Entity> entityClass, Schema schema) {
        this(entityClass, schema.createCollection(MySQLXDao.initCollectionName(entityClass), true));
    }

    public static String initCollectionName(Class<?> clazz) {
        Collection scxModel = clazz.getAnnotation(Collection.class);
        if (scxModel != null && StringUtils.notBlank((String)scxModel.name())) {
            return scxModel.name();
        }
        if (scxModel != null && StringUtils.notBlank((String)scxModel.prefix())) {
            return scxModel.prefix() + "_" + CaseUtils.toSnake((String)clazz.getSimpleName());
        }
        return "scx_" + CaseUtils.toSnake((String)clazz.getSimpleName());
    }

    public static DbDoc toDbDoc(Object entity, FieldFilter updateFilter) {
        JsonNode jsonNode = JsonHelper.OBJECT_MAPPER.valueToTree(entity);
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            ObjectNode newObjectNode = JsonHelper.filterObjectNode(objectNode, updateFilter);
            return (DbDoc)JsonHelper.toJsonValue((JsonNode)newObjectNode);
        }
        throw new IllegalArgumentException("jsonNode \u7c7b\u578b\u4e0d\u4e3a ObjectNode !!!");
    }

    public String add(Entity entity, FieldFilter updateFilter) {
        DbDoc dbDoc = MySQLXDao.toDbDoc(entity, updateFilter.addExcluded(new String[]{"_id"}));
        AddResult addResult = (AddResult)this.collection.add(dbDoc).execute();
        List generatedIds = addResult.getGeneratedIds();
        return (String)generatedIds.get(0);
    }

    public List<String> add(java.util.Collection<Entity> entityList, FieldFilter updateFilter) {
        DbDoc[] dbDocs = new DbDoc[entityList.size()];
        int index = 0;
        for (Entity entity : entityList) {
            dbDocs[index] = MySQLXDao.toDbDoc(entity, updateFilter.addExcluded(new String[]{"_id"}));
            ++index;
        }
        AddResult addResult = (AddResult)this.collection.add(dbDocs).execute();
        return addResult.getGeneratedIds();
    }

    public List<Entity> find(Query query, FieldFilter selectFilter) {
        WhereClause whereClause = MySQLXDaoWhereParser.WHERE_PARSER.parse(query.getWhere());
        FindStatement findStatement = (FindStatement)this.collection.find(whereClause.whereClause()).bind(whereClause.params());
        if (query.getOffset() != null) {
            findStatement.offset(query.getOffset().longValue());
        }
        if (query.getLimit() != null) {
            findStatement.limit(query.getLimit().longValue());
        }
        DocResult docResult = (DocResult)findStatement.execute();
        List dbDocs = docResult.fetchAll();
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (DbDoc dbDoc : dbDocs) {
            list.add(this.toEntity(dbDoc, selectFilter));
        }
        return list;
    }

    public void find(Query query, FieldFilter fieldFilter, Consumer<Entity> consumer) {
        WhereClause whereClause = MySQLXDaoWhereParser.WHERE_PARSER.parse(query.getWhere());
        FindStatement findStatement = (FindStatement)this.collection.find(whereClause.whereClause()).bind(whereClause.params());
        if (query.getOffset() != null) {
            findStatement.offset(query.getOffset().longValue());
        }
        if (query.getLimit() != null) {
            findStatement.limit(query.getLimit().longValue());
        }
        DocResult docResult = (DocResult)findStatement.execute();
        for (DbDoc dbDoc : docResult) {
            consumer.accept(this.toEntity(dbDoc, fieldFilter));
        }
    }

    public Entity get(Query query, FieldFilter fieldFilter) {
        WhereClause whereClause = MySQLXDaoWhereParser.WHERE_PARSER.parse(query.getWhere());
        FindStatement findStatement = ((FindStatement)this.collection.find(whereClause.whereClause()).bind(whereClause.params())).limit(1L);
        DocResult docResult = (DocResult)findStatement.execute();
        DbDoc dbDoc = (DbDoc)docResult.fetchOne();
        return this.toEntity(dbDoc, fieldFilter);
    }

    public long update(Entity entity, Query query, FieldFilter updateFilter) {
        WhereClause whereClause = MySQLXDaoWhereParser.WHERE_PARSER.parse(query.getWhere());
        DbDoc newDoc = MySQLXDao.toDbDoc(entity, updateFilter.addExcluded(new String[]{"_id"}));
        Result result = (Result)((ModifyStatement)this.collection.modify(whereClause.whereClause()).bind(whereClause.params())).patch(newDoc).execute();
        return result.getAffectedItemsCount();
    }

    public long delete(Query query) {
        WhereClause whereClause = MySQLXDaoWhereParser.WHERE_PARSER.parse(query.getWhere());
        Result result = (Result)((RemoveStatement)this.collection.remove(whereClause.whereClause()).bind(whereClause.params())).execute();
        return result.getAffectedItemsCount();
    }

    public long count(Query query) {
        WhereClause whereClause = MySQLXDaoWhereParser.WHERE_PARSER.parse(query.getWhere());
        DocResult docResult = (DocResult)((FindStatement)this.collection.find(whereClause.whereClause()).bind(whereClause.params())).execute();
        return docResult.count();
    }

    public void clear() {
        this.collection.remove("TRUE").execute();
    }

    public Class<Entity> entityClass() {
        return this.entityClass;
    }

    public Entity toEntity(DbDoc dbDoc, FieldFilter filter) {
        try {
            DbDoc newDbDoc = JsonHelper.filterDbDoc(dbDoc, filter);
            JsonNode objectNode = JsonHelper.toObjectNode((JsonValue)newDbDoc);
            return (Entity)this.jsonHelper.objectReader.readValue(objectNode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

