/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.mysql_x.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.exception.ValidParamListIsEmptyException;
import cool.scx.data.query.parser.WhereParser;
import java.util.Arrays;
import java.util.Objects;

public class MySQLXDaoWhereParser
extends WhereParser {
    public static final MySQLXDaoWhereParser WHERE_PARSER = new MySQLXDaoWhereParser();

    public WhereClause parseIsNull(Where w) {
        Object[] whereParams = new Object[]{};
        String whereClause = w.name() + " " + this.getWhereKeyWord(w.whereType());
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseEqual(Where w) {
        Object[] whereParams = new Object[]{w.value1()};
        String whereClause = w.name() + " " + this.getWhereKeyWord(w.whereType()) + " ?";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseLike(Where w) {
        Object[] whereParams = new Object[]{w.value1()};
        String whereClause = w.name() + " " + this.getWhereKeyWord(w.whereType()) + " '%?%'";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseIn(Where w) {
        Object[] whereParams = Arrays.stream(ArrayUtils.toObjectArray((Object)w.value1())).filter(Objects::nonNull).distinct().toArray();
        if (whereParams.length == 0) {
            throw new ValidParamListIsEmptyException(w.whereType());
        }
        String v1 = "(" + StringUtils.repeat((String)"?", (String)", ", (int)whereParams.length) + ")";
        String whereClause = w.name() + " " + this.getWhereKeyWord(w.whereType()) + " " + v1;
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseBetween(Where w) {
        Object[] whereParams = new Object[]{w.value1(), w.value2()};
        String whereClause = w.name() + " " + this.getWhereKeyWord(w.whereType()) + " ? AND ?";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseJsonContains(Where w) {
        Object[] whereParams;
        String v1 = "?";
        if (w.info().useOriginalValue()) {
            whereParams = new Object[]{w.value1()};
        } else {
            try {
                whereParams = new Object[]{ObjectUtils.toJson((Object)w.value1(), (ObjectUtils.Options)new ObjectUtils.Options().setIgnoreJsonIgnore(true).setIgnoreNullValue(true))};
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5(\u65e0\u6cd5\u6b63\u786e\u8f6c\u6362\u4e3a JSON) !!! \u5b57\u6bb5\u540d : " + w.name(), e);
            }
        }
        String whereClause = this.getWhereKeyWord(w.whereType()) + "(" + w.name();
        whereClause = whereClause + ", " + v1 + ")";
        return new WhereClause(whereClause, whereParams);
    }
}

