/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.ConditionType;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.SkipIfInfo;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.serialization.DeserializationException;
import cool.scx.object.ScxObject;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.ValueNode;
import java.util.ArrayList;

public class QueryDeserializer {
    public static Query deserializeQueryFromJson(String json) throws DeserializationException {
        try {
            Node v = ScxObject.fromJson((String)json);
            return QueryDeserializer.deserializeQuery(v);
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    public static Query deserializeQuery(Node v) throws DeserializationException {
        Node limitNode;
        ValueNode vn;
        if (v == null || v.isNull() || !(v instanceof ObjectNode)) {
            throw new DeserializationException("Query node is null or not an object");
        }
        ObjectNode objNode = (ObjectNode)v;
        Node typeNode = objNode.get("@type");
        if (!(typeNode instanceof ValueNode) || !"Query".equals((vn = (ValueNode)typeNode).asText())) {
            throw new DeserializationException("Unknown or missing @type for Query");
        }
        QueryImpl query = new QueryImpl();
        query.where(QueryDeserializer.deserializeWhere(objNode.get("where")));
        query.orderBys(QueryDeserializer.deserializeOrderBys(objNode.get("orderBys")));
        Node offsetNode = objNode.get("offset");
        if (offsetNode instanceof ValueNode) {
            ValueNode offVN = (ValueNode)offsetNode;
            query.offset((long)offVN.asInt());
        }
        if ((limitNode = objNode.get("limit")) instanceof ValueNode) {
            ValueNode limVN = (ValueNode)limitNode;
            query.limit((long)limVN.asInt());
        }
        return query;
    }

    private static Where deserializeWhere(Node node) throws DeserializationException {
        if (node == null || node.isNull()) {
            return null;
        }
        if (!(node instanceof ObjectNode)) {
            throw new DeserializationException("Where node is not an object: " + String.valueOf(node));
        }
        ObjectNode objNode = (ObjectNode)node;
        Node typeNode = objNode.get("@type");
        if (!(typeNode instanceof ValueNode)) {
            throw new DeserializationException("Missing @type in Where node");
        }
        ValueNode typeVN = (ValueNode)typeNode;
        return switch (typeVN.asText()) {
            case "WhereClause" -> QueryDeserializer.deserializeWhereClause(objNode);
            case "And" -> QueryDeserializer.deserializeAnd(objNode);
            case "Or" -> QueryDeserializer.deserializeOr(objNode);
            case "Not" -> QueryDeserializer.deserializeNot(objNode);
            case "Condition" -> QueryDeserializer.deserializeCondition(objNode);
            default -> throw new DeserializationException("Unknown Where type: " + typeVN.asText());
        };
    }

    private static WhereClause deserializeWhereClause(ObjectNode node) {
        String string;
        Node exprNode = node.get("expression");
        Node paramsNode = node.get("params");
        if (exprNode instanceof ValueNode) {
            ValueNode vn = (ValueNode)exprNode;
            string = vn.asText();
        } else {
            string = null;
        }
        String expression = string;
        Object[] params = (Object[])ScxObject.convertValue((Object)paramsNode, Object[].class);
        return new WhereClause(expression, params);
    }

    private static Junction deserializeAnd(ObjectNode node) throws DeserializationException {
        Node clausesNode = node.get("clauses");
        return new And().add(QueryDeserializer.deserializeWhereArray(clausesNode));
    }

    private static Junction deserializeOr(ObjectNode node) throws DeserializationException {
        Node clausesNode = node.get("clauses");
        return new Or().add(QueryDeserializer.deserializeWhereArray(clausesNode));
    }

    private static Not deserializeNot(ObjectNode node) throws DeserializationException {
        Node clauseNode = node.get("clause");
        return new Not(QueryDeserializer.deserializeWhere(clauseNode));
    }

    private static Condition deserializeCondition(ObjectNode node) throws DeserializationException {
        Node selectorNode = node.get("selector");
        if (!(selectorNode instanceof ValueNode)) {
            throw new DeserializationException("Missing selector in Condition");
        }
        ValueNode selectorVN = (ValueNode)selectorNode;
        Node conditionTypeNode = node.get("conditionType");
        if (!(conditionTypeNode instanceof Node)) {
            throw new DeserializationException("Missing conditionType in Condition");
        }
        ConditionType conditionType = (ConditionType)ScxObject.convertValue((Object)conditionTypeNode, ConditionType.class);
        Object value1 = QueryDeserializer.extractValue(node.get("value1"));
        Object value2 = QueryDeserializer.extractValue(node.get("value2"));
        boolean useExpression = QueryDeserializer.getBooleanOrDefault(node.get("useExpression"), false);
        boolean useExpressionValue = QueryDeserializer.getBooleanOrDefault(node.get("useExpressionValue"), false);
        SkipIfInfo skipIfInfo = node.get("skipIfInfo") != null ? QueryDeserializer.deserializeSkipIfInfo(node.get("skipIfInfo")) : new SkipIfInfo(false, false, false, false);
        return new Condition(selectorVN.asText(), conditionType, value1, value2, useExpression, useExpressionValue, skipIfInfo);
    }

    private static Object extractValue(Node node) {
        if (node == null || node.isNull()) {
            return null;
        }
        return ScxObject.convertValue((Object)node, Object.class);
    }

    private static boolean getBooleanOrDefault(Node node, boolean defaultValue) {
        if (node instanceof ValueNode) {
            ValueNode vn = (ValueNode)node;
            return vn.asBoolean();
        }
        return defaultValue;
    }

    private static Where[] deserializeWhereArray(Node arrayNode) throws DeserializationException {
        if (!(arrayNode instanceof ArrayNode)) {
            return new Where[0];
        }
        ArrayNode array = (ArrayNode)arrayNode;
        ArrayList<Where> list = new ArrayList<Where>();
        for (Node n : array) {
            list.add(QueryDeserializer.deserializeWhere(n));
        }
        return (Where[])list.toArray(Where[]::new);
    }

    public static OrderBy[] deserializeOrderBys(Node arrayNode) throws DeserializationException {
        if (!(arrayNode instanceof ArrayNode)) {
            return new OrderBy[0];
        }
        ArrayNode array = (ArrayNode)arrayNode;
        ArrayList<OrderBy> list = new ArrayList<OrderBy>();
        for (Node n : array) {
            list.add(QueryDeserializer.deserializeOrderBy(n));
        }
        return (OrderBy[])list.toArray(OrderBy[]::new);
    }

    private static OrderBy deserializeOrderBy(Node node) throws DeserializationException {
        if (!(node instanceof ObjectNode)) {
            throw new DeserializationException("OrderBy node is not an object: " + String.valueOf(node));
        }
        ObjectNode objNode = (ObjectNode)node;
        Node selectorNode = objNode.get("selector");
        if (!(selectorNode instanceof ValueNode)) {
            throw new DeserializationException("Missing selector in OrderBy");
        }
        ValueNode selectorVN = (ValueNode)selectorNode;
        Node orderByTypeNode = objNode.get("orderByType");
        if (!(orderByTypeNode instanceof Node)) {
            throw new DeserializationException("Missing orderByType in OrderBy");
        }
        OrderByType orderByType = (OrderByType)ScxObject.convertValue((Object)orderByTypeNode, OrderByType.class);
        boolean useExpression = QueryDeserializer.getBooleanOrDefault(objNode.get("useExpression"), false);
        return new OrderBy(selectorVN.asText(), orderByType, useExpression);
    }

    private static SkipIfInfo deserializeSkipIfInfo(Node node) {
        if (!(node instanceof ObjectNode)) {
            return new SkipIfInfo(false, false, false, false);
        }
        ObjectNode objNode = (ObjectNode)node;
        boolean skipIfNull = QueryDeserializer.getBooleanOrDefault(objNode.get("skipIfNull"), false);
        boolean skipIfEmptyList = QueryDeserializer.getBooleanOrDefault(objNode.get("skipIfEmptyList"), false);
        boolean skipIfEmptyString = QueryDeserializer.getBooleanOrDefault(objNode.get("skipIfEmptyString"), false);
        boolean skipIfBlankString = QueryDeserializer.getBooleanOrDefault(objNode.get("skipIfBlankString"), false);
        return new SkipIfInfo(skipIfNull, skipIfEmptyList, skipIfEmptyString, skipIfBlankString);
    }
}

