/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.ConditionType;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.SkipIfInfo;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.serialization.DeserializationException;
import java.util.ArrayList;

public class QueryDeserializer {
    public static Query deserializeQueryFromJson(String json) throws DeserializationException {
        try {
            JsonNode v = ObjectUtils.jsonMapper().readTree(json);
            return QueryDeserializer.deserializeQuery(v);
        }
        catch (JsonProcessingException e) {
            throw new DeserializationException(e);
        }
    }

    public static Query deserializeQuery(JsonNode v) throws DeserializationException {
        if (v == null || v.isNull()) {
            throw new DeserializationException("Query node is null");
        }
        if (!v.isObject()) {
            throw new DeserializationException("Query node is not an object: " + String.valueOf(v));
        }
        JsonNode typeNode = v.get("@type");
        if (typeNode == null || !"Query".equals(typeNode.asText())) {
            throw new DeserializationException("Unknown or missing @type for Query: " + String.valueOf(v));
        }
        QueryImpl query = new QueryImpl();
        Where where = QueryDeserializer.deserializeWhere(v.get("where"));
        query.where(where);
        OrderBy[] orderBys = QueryDeserializer.deserializeOrderBys(v.get("orderBys"));
        query.orderBys(orderBys);
        if (v.has("offset") && !v.get("offset").isNull()) {
            int offset = v.get("offset").asInt();
            query.offset((long)offset);
        }
        if (v.has("limit") && !v.get("limit").isNull()) {
            int limit = v.get("limit").asInt();
            query.limit((long)limit);
        }
        return query;
    }

    private static Where deserializeWhere(JsonNode node) throws DeserializationException {
        String type;
        if (node == null || node.isNull()) {
            return null;
        }
        if (!node.isObject()) {
            throw new DeserializationException("Where node is not an object: " + String.valueOf(node));
        }
        JsonNode typeNode = node.get("@type");
        if (typeNode == null) {
            throw new DeserializationException("Missing @type in Where node: " + String.valueOf(node));
        }
        return switch (type = typeNode.asText()) {
            case "WhereClause" -> QueryDeserializer.deserializeWhereClause(node);
            case "And" -> QueryDeserializer.deserializeAnd(node);
            case "Or" -> QueryDeserializer.deserializeOr(node);
            case "Not" -> QueryDeserializer.deserializeNot(node);
            case "Condition" -> QueryDeserializer.deserializeCondition(node);
            default -> throw new DeserializationException("Unknown Where type: " + type);
        };
    }

    private static WhereClause deserializeWhereClause(JsonNode node) {
        String expression = node.has("expression") ? node.get("expression").asText() : null;
        JsonNode paramsNode = node.get("params");
        Object[] params = (Object[])ObjectUtils.convertValue((Object)paramsNode, Object[].class);
        return new WhereClause(expression, params);
    }

    private static Junction deserializeAnd(JsonNode node) throws DeserializationException {
        JsonNode clausesNode = node.get("clauses");
        Where[] clauses = QueryDeserializer.deserializeWhereArray(clausesNode);
        return new And().add(clauses);
    }

    private static Junction deserializeOr(JsonNode node) throws DeserializationException {
        JsonNode clausesNode = node.get("clauses");
        Where[] clauses = QueryDeserializer.deserializeWhereArray(clausesNode);
        return new Or().add(clauses);
    }

    private static Not deserializeNot(JsonNode node) throws DeserializationException {
        JsonNode clauseNode = node.get("clause");
        Where clause = QueryDeserializer.deserializeWhere(clauseNode);
        return new Not(clause);
    }

    private static Condition deserializeCondition(JsonNode node) throws DeserializationException {
        JsonNode selectorNode = node.get("selector");
        if (selectorNode == null || !selectorNode.isTextual()) {
            throw new DeserializationException("Missing selector in Condition node: " + String.valueOf(node));
        }
        String selector = selectorNode.asText();
        JsonNode conditionTypeNode = node.get("conditionType");
        if (conditionTypeNode == null || !conditionTypeNode.isTextual()) {
            throw new DeserializationException("Missing conditionType in Condition node: " + String.valueOf(node));
        }
        ConditionType conditionType = (ConditionType)ObjectUtils.convertValue((Object)conditionTypeNode, ConditionType.class);
        JsonNode value1Node = node.get("value1");
        JsonNode value2Node = node.get("value2");
        Object value1 = value1Node == null || value1Node.isNull() ? null : ObjectUtils.convertValue((Object)value1Node, Object.class);
        Object value2 = value2Node == null || value2Node.isNull() ? null : ObjectUtils.convertValue((Object)value2Node, Object.class);
        JsonNode useExpressionNode = node.get("useExpression");
        JsonNode useExpressionValueNode = node.get("useExpressionValue");
        JsonNode skipIfInfoNode = node.get("skipIfInfo");
        boolean useExpression = false;
        boolean useExpressionValue = false;
        SkipIfInfo skipIfInfo = new SkipIfInfo(false, false, false, false);
        if (useExpressionNode != null && !useExpressionNode.isNull()) {
            useExpression = useExpressionNode.asBoolean(false);
        }
        if (useExpressionValueNode != null && !useExpressionValueNode.isNull()) {
            useExpressionValue = useExpressionValueNode.asBoolean(false);
        }
        if (skipIfInfoNode != null && !skipIfInfoNode.isNull()) {
            skipIfInfo = QueryDeserializer.deserializeSkipIfInfo(skipIfInfoNode);
        }
        return new Condition(selector, conditionType, value1, value2, useExpression, useExpressionValue, skipIfInfo);
    }

    private static Where[] deserializeWhereArray(JsonNode arrayNode) throws DeserializationException {
        if (arrayNode == null || !arrayNode.isArray()) {
            return new Where[0];
        }
        ArrayList<Where> list = new ArrayList<Where>();
        for (JsonNode node : arrayNode) {
            list.add(QueryDeserializer.deserializeWhere(node));
        }
        return (Where[])list.toArray(Where[]::new);
    }

    public static OrderBy[] deserializeOrderBys(JsonNode arrayNode) throws DeserializationException {
        if (arrayNode == null || !arrayNode.isArray()) {
            return new OrderBy[0];
        }
        ArrayList<OrderBy> list = new ArrayList<OrderBy>();
        for (JsonNode node : arrayNode) {
            list.add(QueryDeserializer.deserializeOrderBy(node));
        }
        return (OrderBy[])list.toArray(OrderBy[]::new);
    }

    private static OrderBy deserializeOrderBy(JsonNode node) throws DeserializationException {
        JsonNode selectorNode = node.get("selector");
        if (selectorNode == null || !selectorNode.isTextual()) {
            throw new DeserializationException("Missing selector in OrderBy node: " + String.valueOf(node));
        }
        String selector = selectorNode.asText();
        JsonNode orderByTypeNode = node.get("orderByType");
        if (orderByTypeNode == null || !orderByTypeNode.isTextual()) {
            throw new DeserializationException("Missing orderByType in OrderBy node: " + String.valueOf(node));
        }
        OrderByType orderByType = (OrderByType)ObjectUtils.convertValue((Object)orderByTypeNode, OrderByType.class);
        JsonNode useExpressionNode = node.get("useExpression");
        boolean useExpression = false;
        if (useExpressionNode != null && !useExpressionNode.isNull()) {
            useExpression = useExpressionNode.asBoolean(false);
        }
        return new OrderBy(selector, orderByType, useExpression);
    }

    private static SkipIfInfo deserializeSkipIfInfo(JsonNode node) {
        if (node == null || node.isNull()) {
            return new SkipIfInfo(false, false, false, false);
        }
        boolean skipIfNull = node.has("skipIfNull") && node.get("skipIfNull").asBoolean(false);
        boolean skipIfEmptyList = node.has("skipIfEmptyList") && node.get("skipIfEmptyList").asBoolean(false);
        boolean skipIfEmptyString = node.has("skipIfEmptyString") && node.get("skipIfEmptyString").asBoolean(false);
        boolean skipIfBlankString = node.has("skipIfBlankString") && node.get("skipIfBlankString").asBoolean(false);
        return new SkipIfInfo(skipIfNull, skipIfEmptyList, skipIfEmptyString, skipIfBlankString);
    }
}

