/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.aggregation.Agg;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.aggregation.ExpressionGroupBy;
import cool.scx.data.aggregation.FieldGroupBy;
import cool.scx.data.aggregation.GroupBy;
import cool.scx.data.serialization.SerializationException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AggregationSerializer {
    public static String serializeAggregationToJson(Aggregation aggregation) throws SerializationException {
        Map<String, Object> v = AggregationSerializer.serializeAggregation(aggregation);
        try {
            return ObjectUtils.jsonMapper().writeValueAsString(v);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException(e);
        }
    }

    public static Map<String, Object> serializeAggregation(Aggregation aggregation) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Aggregation");
        m.put("groupBys", AggregationSerializer.serializeGroupBys(aggregation.getGroupBys()));
        m.put("aggs", AggregationSerializer.serializeAggs(aggregation.getAggs()));
        return m;
    }

    private static Map<String, Object> serializeFieldGroupBy(FieldGroupBy groupBy) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "FieldGroupBy");
        m.put("fieldName", groupBy.fieldName());
        return m;
    }

    private static Map<String, Object> serializeExpressionGroupBy(ExpressionGroupBy groupBy) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "ExpressionGroupBy");
        m.put("alias", groupBy.alias());
        m.put("expression", groupBy.expression());
        return m;
    }

    private static Map<String, Object> serializeAgg(Agg g) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Agg");
        m.put("alias", g.alias());
        m.put("expression", g.expression());
        return m;
    }

    private static List<Map<String, Object>> serializeGroupBys(GroupBy[] groupBys) {
        ArrayList<Map<String, Object>> m = new ArrayList<Map<String, Object>>();
        for (GroupBy groupBy : groupBys) {
            m.add(AggregationSerializer.serializeGroupBy(groupBy));
        }
        return m;
    }

    private static Map<String, Object> serializeGroupBy(GroupBy g) {
        GroupBy groupBy = g;
        Objects.requireNonNull(groupBy);
        GroupBy groupBy2 = groupBy;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FieldGroupBy.class, ExpressionGroupBy.class}, (GroupBy)groupBy2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                FieldGroupBy fieldGroupBy = (FieldGroupBy)groupBy2;
                yield AggregationSerializer.serializeFieldGroupBy(fieldGroupBy);
            }
            case 1 -> {
                ExpressionGroupBy fieldGroupBy = (ExpressionGroupBy)groupBy2;
                yield AggregationSerializer.serializeExpressionGroupBy(fieldGroupBy);
            }
        };
    }

    private static List<Map<String, Object>> serializeAggs(Agg[] aggs) {
        ArrayList<Map<String, Object>> m = new ArrayList<Map<String, Object>>();
        for (Agg agg : aggs) {
            m.add(AggregationSerializer.serializeAgg(agg));
        }
        return m;
    }
}

