/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.VirtualField;
import cool.scx.data.serialization.SerializationException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class FieldPolicySerializer {
    public static String serializeFieldPolicyToJson(FieldPolicy fieldPolicy) throws SerializationException {
        Map<String, Object> m = FieldPolicySerializer.serializeFieldPolicy(fieldPolicy);
        try {
            return ObjectUtils.jsonMapper().writeValueAsString(m);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException(e);
        }
    }

    public static Map<String, Object> serializeFieldPolicy(FieldPolicy fieldPolicy) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "FieldPolicy");
        m.put("filterMode", fieldPolicy.getFilterMode());
        m.put("fieldNames", fieldPolicy.getFieldNames());
        m.put("virtualFields", FieldPolicySerializer.serializeVirtualFields(fieldPolicy.getVirtualFields()));
        m.put("ignoreNull", fieldPolicy.getIgnoreNull());
        m.put("ignoreNulls", fieldPolicy.getIgnoreNulls());
        m.put("assignFields", FieldPolicySerializer.serializeAssignFields(fieldPolicy.getAssignFields()));
        return m;
    }

    private static Map<String, Object> serializeVirtualField(VirtualField virtualField) {
        LinkedHashMap<String, Object> s = new LinkedHashMap<String, Object>();
        s.put("@type", "VirtualField");
        s.put("expression", virtualField.expression());
        s.put("virtualFieldName", virtualField.virtualFieldName());
        return s;
    }

    private static Map<String, Object> serializeAssignField(AssignField assignField) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "AssignField");
        m.put("fieldName", assignField.fieldName());
        m.put("expression", assignField.expression());
        return m;
    }

    private static ArrayList<Object> serializeVirtualFields(VirtualField[] virtualFields) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (VirtualField virtualField : virtualFields) {
            s.add(FieldPolicySerializer.serializeVirtualField(virtualField));
        }
        return s;
    }

    private static ArrayList<Object> serializeAssignFields(AssignField[] assignFields) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (AssignField assignField : assignFields) {
            s.add(FieldPolicySerializer.serializeAssignField(assignField));
        }
        return s;
    }
}

