/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import cool.scx.data.aggregation.Agg;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.aggregation.AggregationImpl;
import cool.scx.data.aggregation.ExpressionGroupBy;
import cool.scx.data.aggregation.FieldGroupBy;
import cool.scx.data.aggregation.GroupBy;
import cool.scx.data.serialization.DeserializationException;
import cool.scx.object.ScxObject;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.ValueNode;
import java.util.ArrayList;

public class AggregationDeserializer {
    public static Aggregation deserializeAggregationFromJson(String json) throws DeserializationException {
        try {
            Node node = ScxObject.fromJson((String)json);
            return AggregationDeserializer.deserializeAggregation(node);
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    public static Aggregation deserializeAggregation(Node v) throws DeserializationException {
        ValueNode vn;
        if (v == null || v.isNull() || !(v instanceof ObjectNode)) {
            throw new DeserializationException("Aggregation node is null or not an ObjectNode");
        }
        ObjectNode objNode = (ObjectNode)v;
        Node typeNode = objNode.get("@type");
        if (!(typeNode instanceof ValueNode) || !"Aggregation".equals((vn = (ValueNode)typeNode).asText())) {
            throw new DeserializationException("Unknown or missing @type for Aggregation: " + String.valueOf(v));
        }
        Node groupBysNode = objNode.get("groupBys");
        if (!(groupBysNode instanceof ArrayNode)) {
            throw new DeserializationException("groupBys node is not an ArrayNode: " + String.valueOf(groupBysNode));
        }
        ArrayNode arrayGroupBys = (ArrayNode)groupBysNode;
        ArrayList<GroupBy> groupByList = new ArrayList<GroupBy>();
        for (Node gbNode : arrayGroupBys) {
            groupByList.add(AggregationDeserializer.deserializeGroupBy(gbNode));
        }
        Node aggsNode = objNode.get("aggs");
        if (!(aggsNode instanceof ArrayNode)) {
            throw new DeserializationException("aggs node is not an ArrayNode: " + String.valueOf(aggsNode));
        }
        ArrayNode arrayAggs = (ArrayNode)aggsNode;
        ArrayList<Agg> aggList = new ArrayList<Agg>();
        for (Node aggNode : arrayAggs) {
            aggList.add(AggregationDeserializer.deserializeAgg(aggNode));
        }
        return new AggregationImpl().aggs((Agg[])aggList.toArray(Agg[]::new)).groupBys((GroupBy[])groupByList.toArray(GroupBy[]::new));
    }

    private static GroupBy deserializeGroupBy(Node node) throws DeserializationException {
        String type;
        if (node == null || node.isNull() || !(node instanceof ObjectNode)) {
            throw new DeserializationException("Invalid GroupBy node");
        }
        ObjectNode objNode = (ObjectNode)node;
        Node typeNode = objNode.get("@type");
        if (!(typeNode instanceof ValueNode)) {
            throw new DeserializationException("Missing or invalid @type in GroupBy node: " + String.valueOf(node));
        }
        ValueNode vn = (ValueNode)typeNode;
        return switch (type = vn.asText()) {
            case "FieldGroupBy" -> AggregationDeserializer.deserializeFieldGroupBy(objNode);
            case "ExpressionGroupBy" -> AggregationDeserializer.deserializeExpressionGroupBy(objNode);
            default -> throw new DeserializationException("Unknown GroupBy type: " + type);
        };
    }

    private static FieldGroupBy deserializeFieldGroupBy(ObjectNode node) throws DeserializationException {
        Node fieldNameNode = node.get("fieldName");
        if (!(fieldNameNode instanceof ValueNode)) {
            throw new DeserializationException("Missing or invalid fieldName in FieldGroupBy: " + String.valueOf(node));
        }
        ValueNode vn = (ValueNode)fieldNameNode;
        return new FieldGroupBy(vn.asText());
    }

    private static ExpressionGroupBy deserializeExpressionGroupBy(ObjectNode node) throws DeserializationException {
        ValueNode aliasVN;
        Node expressionNode;
        block3: {
            block2: {
                Node aliasNode = node.get("alias");
                expressionNode = node.get("expression");
                if (!(aliasNode instanceof ValueNode)) break block2;
                aliasVN = (ValueNode)aliasNode;
                if (expressionNode instanceof ValueNode) break block3;
            }
            throw new DeserializationException("Missing or invalid alias/expression in ExpressionGroupBy: " + String.valueOf(node));
        }
        ValueNode exprVN = (ValueNode)expressionNode;
        return new ExpressionGroupBy(aliasVN.asText(), exprVN.asText());
    }

    private static Agg deserializeAgg(Node node) throws DeserializationException {
        ValueNode aliasVN;
        Node expressionNode;
        block6: {
            block5: {
                ValueNode vn;
                if (node == null || node.isNull() || !(node instanceof ObjectNode)) {
                    throw new DeserializationException("Invalid Agg node: " + String.valueOf(node));
                }
                ObjectNode objNode = (ObjectNode)node;
                Node typeNode = objNode.get("@type");
                if (!(typeNode instanceof ValueNode) || !"Agg".equals((vn = (ValueNode)typeNode).asText())) {
                    throw new DeserializationException("Unknown or missing @type for Agg: " + String.valueOf(node));
                }
                Node aliasNode = objNode.get("alias");
                expressionNode = objNode.get("expression");
                if (!(aliasNode instanceof ValueNode)) break block5;
                aliasVN = (ValueNode)aliasNode;
                if (expressionNode instanceof ValueNode) break block6;
            }
            throw new DeserializationException("Missing or invalid alias/expression in Agg: " + String.valueOf(node));
        }
        ValueNode exprVN = (ValueNode)expressionNode;
        return new Agg(aliasVN.asText(), exprVN.asText());
    }
}

