/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyImpl;
import cool.scx.data.field_policy.FilterMode;
import cool.scx.data.field_policy.VirtualField;
import cool.scx.data.serialization.DeserializationException;
import cool.scx.object.ScxObject;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.ValueNode;
import cool.scx.reflect.TypeReference;
import java.util.ArrayList;
import java.util.Map;

public class FieldPolicyDeserializer {
    public static FieldPolicy deserializeFieldPolicyFromJson(String json) throws DeserializationException {
        try {
            Node node = ScxObject.fromJson((String)json);
            return FieldPolicyDeserializer.deserializeFieldPolicy(node);
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    public static FieldPolicy deserializeFieldPolicy(Node v) throws DeserializationException {
        ValueNode vn;
        if (v == null || v.isNull() || !(v instanceof ObjectNode)) {
            throw new DeserializationException("FieldPolicy node is null or not an object");
        }
        ObjectNode objNode = (ObjectNode)v;
        Node typeNode = objNode.get("@type");
        if (!(typeNode instanceof ValueNode) || !"FieldPolicy".equals((vn = (ValueNode)typeNode).asText())) {
            throw new DeserializationException("Unknown or missing @type for FieldPolicy");
        }
        Node filterModeNode = objNode.get("filterMode");
        if (!(filterModeNode instanceof Node)) {
            throw new DeserializationException("filterMode is missing or null");
        }
        FilterMode filterMode = (FilterMode)ScxObject.convertValue((Object)filterModeNode, FilterMode.class);
        FieldPolicyImpl policy = new FieldPolicyImpl(filterMode);
        Node fieldNamesNode = objNode.get("fieldNames");
        if (!(fieldNamesNode instanceof ArrayNode)) {
            throw new DeserializationException("fieldNames is null or not an array");
        }
        ArrayNode arrayNode = (ArrayNode)fieldNamesNode;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Node fn : arrayNode) {
            if (!(fn instanceof ValueNode)) {
                throw new DeserializationException("Each fieldName must be a ValueNode");
            }
            ValueNode vNode = (ValueNode)fn;
            fieldNames.add(vNode.asText());
        }
        if (filterMode == FilterMode.INCLUDED) {
            policy.include((String[])fieldNames.toArray(String[]::new));
        } else if (filterMode == FilterMode.EXCLUDED) {
            policy.exclude((String[])fieldNames.toArray(String[]::new));
        }
        Node virtualFieldsNode = objNode.get("virtualFields");
        if (!(virtualFieldsNode instanceof ArrayNode)) {
            throw new DeserializationException("virtualFields is null or not an array");
        }
        ArrayNode vfArray = (ArrayNode)virtualFieldsNode;
        ArrayList<VirtualField> virtualFields = new ArrayList<VirtualField>();
        for (Node vfNode : vfArray) {
            virtualFields.add(FieldPolicyDeserializer.deserializeVirtualField(vfNode));
        }
        policy.virtualFields((VirtualField[])virtualFields.toArray(VirtualField[]::new));
        Node assignFieldsNode = objNode.get("assignFields");
        if (!(assignFieldsNode instanceof ArrayNode)) {
            throw new DeserializationException("assignFields is null or not an array");
        }
        ArrayNode afArray = (ArrayNode)assignFieldsNode;
        ArrayList<AssignField> assignFields = new ArrayList<AssignField>();
        for (Node afNode : afArray) {
            assignFields.add(FieldPolicyDeserializer.deserializeAssignField(afNode));
        }
        policy.assignFields((AssignField[])assignFields.toArray(AssignField[]::new));
        Node ignoreNullNode = objNode.get("ignoreNull");
        if (!(ignoreNullNode instanceof ValueNode)) {
            throw new DeserializationException("ignoreNull is missing or invalid");
        }
        ValueNode ignoreVN = (ValueNode)ignoreNullNode;
        policy.ignoreNull(ignoreVN.asBoolean());
        Node ignoreNullsNode = objNode.get("ignoreNulls");
        if (!(ignoreNullsNode instanceof ObjectNode)) {
            throw new DeserializationException("ignoreNulls is not an object");
        }
        ObjectNode ignoreMapNode = (ObjectNode)ignoreNullsNode;
        Map ignoreNulls = (Map)ScxObject.convertValue((Object)ignoreMapNode, (TypeReference)new TypeReference<Map<String, Boolean>>(){});
        for (Map.Entry e : ignoreNulls.entrySet()) {
            policy.ignoreNull((String)e.getKey(), ((Boolean)e.getValue()).booleanValue());
        }
        return policy;
    }

    private static VirtualField deserializeVirtualField(Node node) throws DeserializationException {
        ValueNode nameVN;
        Node exprNode;
        block6: {
            block5: {
                ValueNode vn;
                if (node == null || node.isNull() || !(node instanceof ObjectNode)) {
                    throw new DeserializationException("VirtualField must be an ObjectNode");
                }
                ObjectNode objNode = (ObjectNode)node;
                Node typeNode = objNode.get("@type");
                if (!(typeNode instanceof ValueNode) || !"VirtualField".equals((vn = (ValueNode)typeNode).asText())) {
                    throw new DeserializationException("Invalid or missing @type for VirtualField");
                }
                Node nameNode = objNode.get("virtualFieldName");
                exprNode = objNode.get("expression");
                if (!(nameNode instanceof ValueNode)) break block5;
                nameVN = (ValueNode)nameNode;
                if (exprNode instanceof ValueNode) break block6;
            }
            throw new DeserializationException("virtualFieldName or expression is invalid in VirtualField");
        }
        ValueNode exprVN = (ValueNode)exprNode;
        return new VirtualField(nameVN.asText(), exprVN.asText());
    }

    private static AssignField deserializeAssignField(Node node) throws DeserializationException {
        ValueNode fnVN;
        Node exprNode;
        block6: {
            block5: {
                ValueNode vn;
                if (node == null || node.isNull() || !(node instanceof ObjectNode)) {
                    throw new DeserializationException("AssignField must be an ObjectNode");
                }
                ObjectNode objNode = (ObjectNode)node;
                Node typeNode = objNode.get("@type");
                if (!(typeNode instanceof ValueNode) || !"AssignField".equals((vn = (ValueNode)typeNode).asText())) {
                    throw new DeserializationException("Invalid or missing @type for AssignField");
                }
                Node fieldNameNode = objNode.get("fieldName");
                exprNode = objNode.get("expression");
                if (!(fieldNameNode instanceof ValueNode)) break block5;
                fnVN = (ValueNode)fieldNameNode;
                if (exprNode instanceof ValueNode) break block6;
            }
            throw new DeserializationException("fieldName or expression is invalid in AssignField");
        }
        ValueNode exprVN = (ValueNode)exprNode;
        return new AssignField(fnVN.asText(), exprVN.asText());
    }
}

