/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.Query;
import cool.scx.data.query.SkipIfInfo;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.serialization.SerializationException;
import cool.scx.object.ScxObject;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.serializer.NodeSerializeException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QuerySerializer {
    public static String serializeQueryToJson(Query query) throws SerializationException {
        Map<String, Object> v = QuerySerializer.serializeQuery(query);
        try {
            return ScxObject.toJson(v);
        }
        catch (NodeMappingException | NodeSerializeException e) {
            throw new SerializationException(e);
        }
    }

    public static Map<String, Object> serializeQuery(Query query) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Query");
        m.put("where", QuerySerializer.serializeWhere(query.getWhere()));
        m.put("orderBys", QuerySerializer.serializeOrderBys(query.getOrderBys()));
        m.put("offset", query.getOffset());
        m.put("limit", query.getLimit());
        return m;
    }

    public static Map<String, Object> serializeWhere(Where obj) {
        Where where = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WhereClause.class, And.class, Or.class, Not.class, Condition.class}, (Where)where, n)) {
            case 0 -> {
                WhereClause w = (WhereClause)where;
                yield QuerySerializer.serializeWhereClause(w);
            }
            case 1 -> {
                And a = (And)where;
                yield QuerySerializer.serializeAnd(a);
            }
            case 2 -> {
                Or o = (Or)where;
                yield QuerySerializer.serializeOr(o);
            }
            case 3 -> {
                Not n = (Not)where;
                yield QuerySerializer.serializeNot(n);
            }
            case 4 -> {
                Condition conditionBody = (Condition)where;
                yield QuerySerializer.serializeCondition(conditionBody);
            }
            case -1 -> null;
            default -> throw new IllegalArgumentException("Unknown Where type: " + String.valueOf(obj));
        };
    }

    private static Map<String, Object> serializeWhereClause(WhereClause w) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "WhereClause");
        m.put("expression", w.expression());
        m.put("params", w.params());
        return m;
    }

    private static Map<String, Object> serializeAnd(And a) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "And");
        m.put("clauses", QuerySerializer.serializeWhereAll(a.clauses()));
        return m;
    }

    private static Map<String, Object> serializeOr(Or o) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Or");
        m.put("clauses", QuerySerializer.serializeWhereAll(o.clauses()));
        return m;
    }

    private static Map<String, Object> serializeNot(Not n) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Not");
        m.put("clause", QuerySerializer.serializeWhere(n.clause()));
        return m;
    }

    private static Map<String, Object> serializeCondition(Condition w) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Condition");
        m.put("selector", w.selector());
        m.put("conditionType", w.conditionType());
        m.put("value1", w.value1());
        m.put("value2", w.value2());
        m.put("useExpression", w.useExpression());
        m.put("useExpressionValue", w.useExpressionValue());
        m.put("skipIfInfo", QuerySerializer.serializeSkipIfInfo(w.skipIfInfo()));
        return m;
    }

    private static List<Object> serializeWhereAll(Where[] objs) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (Where obj : objs) {
            s.add(QuerySerializer.serializeWhere(obj));
        }
        return s;
    }

    public static List<Object> serializeOrderBys(OrderBy[] objs) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (OrderBy obj : objs) {
            s.add(QuerySerializer.serializeOrderBy(obj));
        }
        return s;
    }

    private static Map<String, Object> serializeOrderBy(OrderBy orderByBody) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "OrderBy");
        m.put("selector", orderByBody.selector());
        m.put("orderByType", orderByBody.orderByType());
        m.put("useExpression", orderByBody.useExpression());
        return m;
    }

    private static Map<String, Object> serializeSkipIfInfo(SkipIfInfo info) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "SkipIfInfo");
        m.put("skipIfNull", info.skipIfNull());
        m.put("skipIfEmptyList", info.skipIfEmptyList());
        m.put("skipIfEmptyString", info.skipIfEmptyString());
        m.put("skipIfBlankString", info.skipIfBlankString());
        return m;
    }
}

