/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.dialect;

import cool.scx.data.jdbc.dialect.Dialect;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.sql.DataSource;

public final class DialectSelector {
    private static final List<Dialect> DIALECT_LIST = new ArrayList<Dialect>();

    public static Dialect findDialect(Driver realDriver) {
        for (Dialect dialect : DIALECT_LIST) {
            if (!dialect.canHandle(realDriver)) continue;
            return dialect;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u8a00 !!! " + realDriver.getClass().getName());
    }

    public static Dialect findDialect(DataSource dataSource) {
        for (Dialect dialect : DIALECT_LIST) {
            if (!dialect.canHandle(dataSource)) continue;
            return dialect;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u8a00 !!! " + dataSource.getClass().getName());
    }

    static {
        ServiceLoader<Dialect> loader = ServiceLoader.load(Dialect.class);
        for (Dialect dialect : loader) {
            DIALECT_LIST.add(dialect);
        }
    }
}

