/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.dialect;

import cool.scx.data.jdbc.dialect.Dialect;
import cool.scx.data.jdbc.mapping.Column;
import cool.scx.util.StringUtils;
import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.sqlite.JDBC;
import org.sqlite.SQLiteDataSource;
import org.sqlite.core.CorePreparedStatement;
import org.sqlite.core.CoreStatement;
import org.sqlite.jdbc4.JDBC4PreparedStatement;

public class SQLiteDialect
implements Dialect {
    static final Field CoreStatement_sql;
    static final Field CoreStatement_batch;
    static final Field CorePreparedStatement_batchQueryCount;

    @Override
    public boolean canHandle(DataSource dataSource) {
        try {
            return dataSource instanceof SQLiteDataSource || dataSource.isWrapperFor(SQLiteDataSource.class);
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean canHandle(Driver driver) {
        return driver instanceof JDBC;
    }

    @Override
    public String getFinalSQL(Statement statement) {
        int batchQuertCount;
        Object[] batch;
        String sql;
        CorePreparedStatement corePreparedStatement;
        try {
            corePreparedStatement = (CorePreparedStatement)statement.unwrap(JDBC4PreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            sql = (String)CoreStatement_sql.get(corePreparedStatement);
            batch = (Object[])CoreStatement_batch.get(corePreparedStatement);
            batchQuertCount = (Integer)CorePreparedStatement_batchQueryCount.get(corePreparedStatement);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int currentParameter = 0;
        for (int pos = 0; pos < sql.length(); ++pos) {
            char character = sql.charAt(pos);
            if (character == '?' && currentParameter <= batch.length) {
                Object value = batch[currentParameter];
                sb.append(value != null ? value.toString() : "NULL");
                ++currentParameter;
                continue;
            }
            sb.append(character);
        }
        String finalSQL = sb.toString();
        return batchQuertCount > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchQuertCount - 1) + " \u9879" : finalSQL;
    }

    @Override
    public String getLimitSQL(String sql, Long offset, Long rowCount) {
        String limitClauses = rowCount == null ? "" : (offset == null || offset == 0L ? " LIMIT " + rowCount : " LIMIT " + offset + "," + rowCount);
        return sql + limitClauses;
    }

    @Override
    public String getDataTypeDefinitionByClass(Class<?> javaType) {
        if (javaType == Integer.class || javaType == Long.class) {
            return "INTEGER";
        }
        if (javaType == String.class) {
            return "TEXT";
        }
        return "BLOB";
    }

    @Override
    public List<String> getColumnConstraint(Column column) {
        ArrayList<String> list = new ArrayList<String>();
        if (column.primaryKey() && column.autoIncrement()) {
            list.add("PRIMARY KEY AUTOINCREMENT");
        }
        list.add(column.notNull() || column.primaryKey() ? "NOT NULL" : "NULL");
        if (column.unique()) {
            list.add("UNIQUE");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            list.add("DEFAULT " + column.defaultValue());
        }
        return list;
    }

    static {
        try {
            CoreStatement_sql = CoreStatement.class.getDeclaredField("sql");
            CoreStatement_batch = CoreStatement.class.getDeclaredField("batch");
            CorePreparedStatement_batchQueryCount = CorePreparedStatement.class.getDeclaredField("batchQueryCount");
            CoreStatement_sql.setAccessible(true);
            CoreStatement_batch.setAccessible(true);
            CorePreparedStatement_batchQueryCount.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

