/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.meta_data;

import cool.scx.data.jdbc.meta_data.CatalogMetaData;
import cool.scx.data.jdbc.meta_data.ColumnMetaData;
import cool.scx.data.jdbc.meta_data.IndexMetaData;
import cool.scx.data.jdbc.meta_data.KeyMetaData;
import cool.scx.data.jdbc.meta_data.SchemaMetaData;
import cool.scx.data.jdbc.meta_data.TableMetaData;
import cool.scx.data.jdbc.result_handler.ResultHandler;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MetaDataHelper {
    private static final ResultHandler<List<_Catalog>> CATALOG_LIST_HANDLER = ResultHandler.ofBeanList(_Catalog.class);
    private static final ResultHandler<List<_Schema>> SCHEMA_LIST_HANDLER = ResultHandler.ofBeanList(_Schema.class);
    private static final ResultHandler<List<_Table>> TABLE_LIST_HANDLER = ResultHandler.ofBeanList(_Table.class);
    private static final ResultHandler<List<_Column>> COLUMN_LIST_HANDLER = ResultHandler.ofBeanList(_Column.class);
    private static final ResultHandler<List<_PrimaryKey>> PRIMARY_KEY_LIST_HANDLER = ResultHandler.ofBeanList(_PrimaryKey.class);
    private static final ResultHandler<List<_IndexInfo>> INDEX_INFO_LIST_HANDLER = ResultHandler.ofBeanList(_IndexInfo.class);

    public static List<_Catalog> getCatalogs(DatabaseMetaData dbMetaData) throws SQLException {
        List<_Catalog> catalogs = (List<_Catalog>)CATALOG_LIST_HANDLER.apply(dbMetaData.getCatalogs());
        if (catalogs.size() == 0) {
            catalogs = List.of(new _Catalog(null));
        }
        return catalogs;
    }

    public static List<_Schema> getSchemas(DatabaseMetaData dbMetaData, String catalog, String schemaPattern) throws SQLException {
        List<_Schema> schemas = (List<_Schema>)SCHEMA_LIST_HANDLER.apply(dbMetaData.getSchemas(catalog, schemaPattern));
        if (schemas.size() == 0) {
            schemas = List.of(new _Schema(null, catalog));
        }
        return schemas;
    }

    public static List<_Table> getTables(DatabaseMetaData dbMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return (List)TABLE_LIST_HANDLER.apply(dbMetaData.getTables(catalog, schemaPattern, tableNamePattern, types));
    }

    public static List<_Column> getColumns(DatabaseMetaData dbMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return (List)COLUMN_LIST_HANDLER.apply(dbMetaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    public static List<_PrimaryKey> getPrimaryKeys(DatabaseMetaData dbMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return (List)PRIMARY_KEY_LIST_HANDLER.apply(dbMetaData.getPrimaryKeys(catalog, schemaPattern, tableNamePattern));
    }

    public static List<_IndexInfo> getIndexInfo(DatabaseMetaData dbMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        Map s = (Map)ResultHandler.ofMap().apply(dbMetaData.getIndexInfo(catalog, schema, table, unique, approximate));
        return (List)INDEX_INFO_LIST_HANDLER.apply(dbMetaData.getIndexInfo(catalog, schema, table, unique, approximate));
    }

    public static CatalogMetaData[] initCatalogs(DatabaseMetaData dbMetaData) {
        try {
            List<_Catalog> catalogs = MetaDataHelper.getCatalogs(dbMetaData);
            if (catalogs.size() > 0) {
                return (CatalogMetaData[])catalogs.stream().map(_Catalog::toCatalogMetaData).toArray(CatalogMetaData[]::new);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new CatalogMetaData[]{new CatalogMetaData(null)};
    }

    public static SchemaMetaData[] initSchemas(DatabaseMetaData dbMetaData, String catalog, String schemaPattern) {
        try {
            List<_Schema> schemas = MetaDataHelper.getSchemas(dbMetaData, catalog, schemaPattern);
            return (SchemaMetaData[])schemas.stream().map(_Schema::toSchemaMetaData).toArray(SchemaMetaData[]::new);
        }
        catch (SQLException sQLException) {
            return new SchemaMetaData[]{new SchemaMetaData(catalog, null)};
        }
    }

    public static TableMetaData[] initTables(DatabaseMetaData dbMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        try {
            List<_Table> tables = MetaDataHelper.getTables(dbMetaData, catalog, schemaPattern, tableNamePattern, types);
            return (TableMetaData[])tables.stream().map(_Table::toTableMetaData).toArray(TableMetaData[]::new);
        }
        catch (SQLException sQLException) {
            return new TableMetaData[0];
        }
    }

    public static ColumnMetaData[] initColumns(DatabaseMetaData dbMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, TableMetaData tableMetaData) {
        try {
            List<_Column> columns = MetaDataHelper.getColumns(dbMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
            return (ColumnMetaData[])columns.stream().map(column -> column.toColumnMetaData(tableMetaData)).toArray(ColumnMetaData[]::new);
        }
        catch (SQLException e) {
            return new ColumnMetaData[0];
        }
    }

    public static KeyMetaData[] initPrimaryKeys(DatabaseMetaData dbMetaData, String catalog, String schemaPattern, String tableNamePattern) {
        try {
            List<_PrimaryKey> primaryKeys = MetaDataHelper.getPrimaryKeys(dbMetaData, catalog, schemaPattern, tableNamePattern);
            return (KeyMetaData[])primaryKeys.stream().map(_PrimaryKey::toPrimaryKeyMetaData).toArray(KeyMetaData[]::new);
        }
        catch (SQLException e) {
            return new KeyMetaData[0];
        }
    }

    public static IndexMetaData[] initIndexInfo(DatabaseMetaData dbMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) {
        try {
            List<_IndexInfo> indexInfo = MetaDataHelper.getIndexInfo(dbMetaData, catalog, schema, table, unique, approximate);
            return (IndexMetaData[])indexInfo.stream().map(_IndexInfo::toIndexInfoMetaData).toArray(IndexMetaData[]::new);
        }
        catch (SQLException e) {
            return new IndexMetaData[0];
        }
    }

    public static Map<String, ColumnMetaData> toColumnsMap(ColumnMetaData[] columns) {
        HashMap<String, ColumnMetaData> map = new HashMap<String, ColumnMetaData>();
        for (ColumnMetaData column : columns) {
            map.put(column.name(), column);
        }
        return map;
    }

    public static Map<String, TableMetaData> toTablesMap(TableMetaData[] columns) {
        HashMap<String, TableMetaData> map = new HashMap<String, TableMetaData>();
        for (TableMetaData column : columns) {
            map.put(column.name(), column);
        }
        return map;
    }

    public static boolean checkPrimaryKey(TableMetaData table, String columnName) {
        for (KeyMetaData primaryKey : table.keys()) {
            if (!Objects.equals(primaryKey.columnName(), columnName)) continue;
            return true;
        }
        return false;
    }

    public static IndexMetaData checkIndex(TableMetaData table, String columnName) {
        for (IndexMetaData indexInfoMetaData : table.indexes()) {
            if (!Objects.equals(indexInfoMetaData.columnName(), columnName)) continue;
            return indexInfoMetaData;
        }
        return null;
    }

    public record _Catalog(String TABLE_CAT) {
        public CatalogMetaData toCatalogMetaData() {
            return new CatalogMetaData(this.TABLE_CAT);
        }
    }

    public record _Schema(String TABLE_SCHEM, String TABLE_CATALOG) {
        public SchemaMetaData toSchemaMetaData() {
            return new SchemaMetaData(this.TABLE_CATALOG, this.TABLE_SCHEM);
        }
    }

    public record _Column(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, String COLUMN_NAME, int DATA_TYPE, String TYPE_NAME, int COLUMN_SIZE, String BUFFER_LENGTH, int DECIMAL_DIGITS, int NUM_PREC_RADIX, int NULLABLE, String REMARKS, String COLUMN_DEF, int SQL_DATA_TYPE, int SQL_DATETIME_SUB, int CHAR_OCTET_LENGTH, int ORDINAL_POSITION, String IS_NULLABLE, String SCOPE_CATALOG, String SCOPE_SCHEMA, String SCOPE_TABLE, short SOURCE_DATA_TYPE, String IS_AUTOINCREMENT, String IS_GENERATEDCOLUMN) {
        public ColumnMetaData toColumnMetaData(TableMetaData tableMetaData) {
            boolean notNull = Objects.equals("NO", this.IS_NULLABLE);
            boolean isAutoincrement = Objects.equals("YES", this.IS_AUTOINCREMENT);
            boolean primaryKey = MetaDataHelper.checkPrimaryKey(tableMetaData, this.COLUMN_NAME);
            boolean index = false;
            boolean unique = false;
            IndexMetaData indexMetaData = MetaDataHelper.checkIndex(tableMetaData, this.COLUMN_NAME);
            if (indexMetaData != null) {
                index = true;
                if (indexMetaData.unique()) {
                    unique = true;
                }
            }
            return new ColumnMetaData(this.TABLE_NAME, this.COLUMN_NAME, this.TYPE_NAME, this.COLUMN_SIZE, notNull, isAutoincrement, unique, primaryKey, index, this.COLUMN_DEF, null, this.REMARKS);
        }
    }

    public record _Table(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, String TABLE_TYPE, String REMARKS, String TYPE_CAT, String TYPE_SCHEM, String TYPE_NAME, String SELF_REFERENCING_COL_NAME, String REF_GENERATION) {
        public TableMetaData toTableMetaData() {
            return new TableMetaData(this.TABLE_CAT, this.TABLE_SCHEM, this.TABLE_NAME, this.REMARKS);
        }
    }

    public record _PrimaryKey(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, String COLUMN_NAME, short KEY_SEQ, String PK_NAME) {
        public KeyMetaData toPrimaryKeyMetaData() {
            return new KeyMetaData(this.PK_NAME, this.COLUMN_NAME, true);
        }
    }

    public record _IndexInfo(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, boolean NON_UNIQUE, String INDEX_QUALIFIER, String INDEX_NAME, short TYPE, short ORDINAL_POSITION, String COLUMN_NAME, String ASC_OR_DESC, long CARDINALITY, long PAGES, String FILTER_CONDITION) {
        public IndexMetaData toIndexInfoMetaData() {
            return new IndexMetaData(this.INDEX_NAME, this.COLUMN_NAME, !this.NON_UNIQUE);
        }
    }
}

