/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.data.jdbc.parser.ColumnNameParser;
import cool.scx.data.jdbc.sql.SQL;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import cool.scx.data.query.exception.ValidParamListIsEmptyException;
import cool.scx.data.query.parser.WhereClauseAndWhereParams;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

interface WhereTypeHandler {
    public static final WhereTypeHandler IS_NULL_HANDLER;
    public static final WhereTypeHandler IS_NOT_NULL_HANDLER;
    public static final WhereTypeHandler EQUAL_HANDLER;
    public static final WhereTypeHandler NOT_EQUAL_HANDLER;
    public static final WhereTypeHandler LESS_THAN_HANDLER;
    public static final WhereTypeHandler LESS_THAN_OR_EQUAL_HANDLER;
    public static final WhereTypeHandler GREATER_THAN_HANDLER;
    public static final WhereTypeHandler GREATER_THAN_OR_EQUAL_HANDLER;
    public static final WhereTypeHandler LIKE_REGEX_HANDLER;
    public static final WhereTypeHandler NOT_LIKE_REGEX_HANDLER;
    public static final WhereTypeHandler LIKE_HANDLER;
    public static final WhereTypeHandler NOT_LIKE_HANDLER;
    public static final WhereTypeHandler IN_HANDLER;
    public static final WhereTypeHandler NOT_IN_HANDLER;
    public static final WhereTypeHandler BETWEEN_HANDLER;
    public static final WhereTypeHandler NOT_BETWEEN_HANDLER;
    public static final WhereTypeHandler JSON_CONTAINS_HANDLER;

    public WhereClauseAndWhereParams getWhereParamsAndWhereClause(Table<?> var1, String var2, WhereType var3, Object var4, Object var5, WhereOption.Info var6);

    static {
        IS_NOT_NULL_HANDLER = IS_NULL_HANDLER = (tableInfo, name, whereType, value1, value2, info) -> {
            String columnName = ColumnNameParser.parseColumnName(tableInfo, name, info.useJsonExtract(), info.useOriginalName());
            Object[] whereParams = new Object[]{};
            String whereClause = columnName + " " + whereType.keyWord();
            return new WhereClauseAndWhereParams(whereClause, whereParams);
        };
        NOT_EQUAL_HANDLER = EQUAL_HANDLER = (tableInfo, name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            Object v1;
            String columnName = ColumnNameParser.parseColumnName(tableInfo, name, info.useJsonExtract(), info.useOriginalName());
            if (value1 instanceof SQL) {
                SQL a = (SQL)value1;
                v1 = "(" + a.sql() + ")";
                whereParams = a.params();
            } else {
                v1 = "?";
                whereParams = new Object[]{value1};
            }
            String whereClause = columnName + " " + whereType.keyWord() + " " + (String)v1;
            return new WhereClauseAndWhereParams(whereClause, whereParams);
        };
        LESS_THAN_HANDLER = EQUAL_HANDLER;
        LESS_THAN_OR_EQUAL_HANDLER = EQUAL_HANDLER;
        GREATER_THAN_HANDLER = EQUAL_HANDLER;
        GREATER_THAN_OR_EQUAL_HANDLER = EQUAL_HANDLER;
        LIKE_REGEX_HANDLER = EQUAL_HANDLER;
        NOT_LIKE_REGEX_HANDLER = EQUAL_HANDLER;
        NOT_LIKE_HANDLER = LIKE_HANDLER = (tableInfo, name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            Object v1;
            String columnName = ColumnNameParser.parseColumnName(tableInfo, name, info.useJsonExtract(), info.useOriginalName());
            if (value1 instanceof SQL) {
                SQL a = (SQL)value1;
                v1 = "(" + a.sql() + ")";
                whereParams = a.params();
            } else {
                v1 = "?";
                whereParams = new Object[]{value1};
            }
            String whereClause = columnName + " " + whereType.keyWord() + " CONCAT('%'," + (String)v1 + ",'%')";
            return new WhereClauseAndWhereParams(whereClause, whereParams);
        };
        NOT_IN_HANDLER = IN_HANDLER = (tableInfo, name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            String v1;
            String columnName = ColumnNameParser.parseColumnName(tableInfo, name, info.useJsonExtract(), info.useOriginalName());
            if (value1 instanceof SQL) {
                SQL a = (SQL)value1;
                v1 = "(" + a.sql() + ")";
                whereParams = a.params();
            } else {
                whereParams = Arrays.stream(ObjectUtils.toObjectArray((Object)value1)).filter(Objects::nonNull).distinct().toArray();
                if (whereParams.length == 0) {
                    throw new ValidParamListIsEmptyException(whereType);
                }
                v1 = "(" + StringUtils.repeat((String)"?", (String)", ", (int)whereParams.length) + ")";
            }
            String whereClause = columnName + " " + whereType.keyWord() + " " + v1;
            return new WhereClauseAndWhereParams(whereClause, whereParams);
        };
        NOT_BETWEEN_HANDLER = BETWEEN_HANDLER = (tableInfo, name, whereType, value1, value2, info) -> {
            Object v2;
            Object v1;
            SQL a;
            String columnName = ColumnNameParser.parseColumnName(tableInfo, name, info.useJsonExtract(), info.useOriginalName());
            ArrayList<Object> whereParams = new ArrayList<Object>();
            if (value1 instanceof SQL) {
                a = (SQL)value1;
                v1 = "(" + a.sql() + ")";
                Collections.addAll(whereParams, a.params());
            } else {
                v1 = "?";
                whereParams.add(value1);
            }
            if (value2 instanceof SQL) {
                a = (SQL)value2;
                v2 = "(" + a.sql() + ")";
                Collections.addAll(whereParams, a.params());
            } else {
                v2 = "?";
                whereParams.add(value2);
            }
            String whereClause = columnName + " " + whereType.keyWord() + " " + (String)v1 + " AND " + (String)v2;
            return new WhereClauseAndWhereParams(whereClause, whereParams.toArray());
        };
        JSON_CONTAINS_HANDLER = (tableInfo, name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            Object v1;
            String columnName;
            ColumnNameParser.ColumnNameAndFieldPath c = ColumnNameParser.splitIntoColumnNameAndFieldPath(name);
            String string = columnName = info.useOriginalName() ? c.columnName() : tableInfo.getColumn(c.columnName()).name();
            if (StringUtils.isBlank((String)c.columnName())) {
                throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + name);
            }
            if (value1 instanceof SQL) {
                SQL a = (SQL)value1;
                v1 = "(" + a.sql() + ")";
                whereParams = a.params();
            } else {
                v1 = "?";
                if (info.useOriginalValue()) {
                    whereParams = new Object[]{value1};
                } else {
                    try {
                        whereParams = new Object[]{ObjectUtils.toJson((Object)value1, (ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE, ObjectUtils.Option.IGNORE_NULL_VALUE})};
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5(\u65e0\u6cd5\u6b63\u786e\u8f6c\u6362\u4e3a JSON) !!! \u5b57\u6bb5\u540d : " + name, e);
                    }
                }
            }
            String whereClause = whereType.keyWord() + "(" + columnName;
            whereClause = StringUtils.notBlank((String)c.fieldPath()) ? whereClause + ", " + (String)v1 + ", '$" + c.fieldPath() + "')" : whereClause + ", " + (String)v1 + ")";
            return new WhereClauseAndWhereParams(whereClause, whereParams);
        };
    }
}

