/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.result_handler;

import cool.scx.data.jdbc.bean_builder.BeanBuilder;
import cool.scx.data.jdbc.result_handler.BeanConsumerHandler;
import cool.scx.data.jdbc.result_handler.BeanHandler;
import cool.scx.data.jdbc.result_handler.BeanListHandler;
import cool.scx.data.jdbc.result_handler.MapConsumerHandler;
import cool.scx.data.jdbc.result_handler.MapHandler;
import cool.scx.data.jdbc.result_handler.MapListHandler;
import cool.scx.data.jdbc.result_handler.SingleValueHandler;
import cool.scx.functional.ScxFunction;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ResultHandler<T>
extends ScxFunction<ResultSet, T, SQLException> {
    public static ResultHandler<Map<String, Object>> ofMap() {
        return MapHandler.INSTANCE;
    }

    public static ResultHandler<Map<String, Object>> ofMap(Supplier<Map<String, Object>> mapSupplier) {
        return new MapHandler(mapSupplier);
    }

    public static ResultHandler<List<Map<String, Object>>> ofMapList() {
        return MapListHandler.INSTANCE;
    }

    public static ResultHandler<List<Map<String, Object>>> ofMapList(Supplier<Map<String, Object>> mapSupplier) {
        return new MapListHandler(mapSupplier);
    }

    public static <C> ResultHandler<C> ofBean(Class<C> clazz) {
        return new BeanHandler<C>(BeanBuilder.of(clazz));
    }

    public static <C> ResultHandler<C> ofBean(Class<C> clazz, Function<Field, String> columnNameMapping) {
        return new BeanHandler<C>(BeanBuilder.of(clazz, columnNameMapping));
    }

    public static <C> ResultHandler<List<C>> ofBeanList(Class<C> clazz) {
        return new BeanListHandler<C>(BeanBuilder.of(clazz));
    }

    public static <C> ResultHandler<List<C>> ofBeanList(Class<C> clazz, Function<Field, String> columnNameMapping) {
        return new BeanListHandler<C>(BeanBuilder.of(clazz, columnNameMapping));
    }

    public static <C> ResultHandler<Void> ofBeanConsumer(Class<C> clazz, Consumer<C> consumer) {
        return new BeanConsumerHandler<C>(BeanBuilder.of(clazz), consumer);
    }

    public static <C> ResultHandler<Void> ofBeanConsumer(Class<C> clazz, Function<Field, String> columnNameMapping, Consumer<C> consumer) {
        return new BeanConsumerHandler<C>(BeanBuilder.of(clazz, columnNameMapping), consumer);
    }

    public static ResultHandler<Void> ofMapConsumer(Consumer<Map<String, Object>> consumer) {
        return new MapConsumerHandler(consumer);
    }

    public static ResultHandler<Void> ofMapConsumer(Supplier<Map<String, Object>> mapSupplier, Consumer<Map<String, Object>> consumer) {
        return new MapConsumerHandler(mapSupplier, consumer);
    }

    public static <C> ResultHandler<C> ofSingleValue(String columnName, Class<C> clazz) {
        return new SingleValueHandler<C>(columnName, clazz);
    }

    public static <C> ResultHandler<C> ofSingleValue(int columnIndex, Class<C> clazz) {
        return new SingleValueHandler<C>(columnIndex, clazz);
    }

    default public PreparedStatement beforeExecuteQuery(PreparedStatement preparedStatement) throws SQLException {
        return preparedStatement;
    }
}

