/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.result_handler;

import cool.scx.data.jdbc.result_handler.ResultHandler;
import java.sql.ResultSet;
import java.sql.SQLException;

final class SingleValueHandler<T>
implements ResultHandler<T> {
    private final int columnIndex;
    private final String columnName;
    private final Class<T> clazz;
    private final boolean useName;

    public SingleValueHandler() {
        this(1, null);
    }

    public SingleValueHandler(Class<T> clazz) {
        this(1, clazz);
    }

    public SingleValueHandler(int columnIndex) {
        this(columnIndex, null);
    }

    public SingleValueHandler(String columnName) {
        this(columnName, null);
    }

    public SingleValueHandler(int columnIndex, Class<T> clazz) {
        this(columnIndex, null, clazz, false);
    }

    public SingleValueHandler(String columnName, Class<T> clazz) {
        this(1, columnName, clazz, true);
    }

    private SingleValueHandler(int columnIndex, String columnName, Class<T> clazz, boolean useName) {
        this.columnIndex = columnIndex;
        this.columnName = columnName;
        this.clazz = clazz;
        this.useName = useName;
    }

    public T apply(ResultSet rs) throws SQLException {
        if (rs.next()) {
            if (this.clazz == null) {
                return (T)(this.useName ? rs.getObject(this.columnName) : rs.getObject(this.columnIndex));
            }
            return this.useName ? rs.getObject(this.columnName, this.clazz) : rs.getObject(this.columnIndex, this.clazz);
        }
        return null;
    }
}

