/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql;

import cool.scx.data.jdbc.sql.PlaceholderSQL;
import cool.scx.data.jdbc.sql.SQL;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class NamedParameterSQL
implements SQL {
    private static final Pattern NAMED_PARAMETER_PATTERN = Pattern.compile(":([\\w.-]+)");
    private final String[] namedParameterNameIndex;
    private final PlaceholderSQL placeholderSQL;

    public NamedParameterSQL(String namedParameterSQL, Map<String, Object> params) {
        NormalSQLAndNamedParameterNameIndex t = NamedParameterSQL.initNamedParameterNameIndex(namedParameterSQL);
        String normalSQL = t.normalSQL();
        this.namedParameterNameIndex = t.namedParameterNameIndex();
        this.placeholderSQL = new PlaceholderSQL(normalSQL, this.mapToArray(params));
    }

    public NamedParameterSQL(String namedParameterSQL, List<Map<String, Object>> batchParams) {
        NormalSQLAndNamedParameterNameIndex t = NamedParameterSQL.initNamedParameterNameIndex(namedParameterSQL);
        String normalSQL = t.normalSQL();
        this.namedParameterNameIndex = t.namedParameterNameIndex();
        this.placeholderSQL = new PlaceholderSQL(normalSQL, batchParams.stream().map(this::mapToArray).toList());
    }

    private static NormalSQLAndNamedParameterNameIndex initNamedParameterNameIndex(String namedParameterSQL) {
        Matcher matcher = NAMED_PARAMETER_PATTERN.matcher(namedParameterSQL);
        StringBuilder normalSQL = new StringBuilder();
        ArrayList<String> tempNameIndexList = new ArrayList<String>();
        while (matcher.find()) {
            matcher.appendReplacement(normalSQL, "?");
            tempNameIndexList.add(matcher.group(1));
        }
        matcher.appendTail(normalSQL);
        return new NormalSQLAndNamedParameterNameIndex(normalSQL.toString(), (String[])tempNameIndexList.toArray(String[]::new));
    }

    @Override
    public String sql() {
        return this.placeholderSQL.sql();
    }

    @Override
    public Object[] params() {
        return this.placeholderSQL.params();
    }

    @Override
    public PreparedStatement fillParams(PreparedStatement preparedStatement) throws SQLException {
        return this.placeholderSQL.fillParams(preparedStatement);
    }

    private Object[] mapToArray(Map<String, Object> objectMap) {
        Object[] objectArray = new Object[this.namedParameterNameIndex.length];
        for (int i = 0; i < this.namedParameterNameIndex.length; ++i) {
            objectArray[i] = objectMap.get(this.namedParameterNameIndex[i]);
        }
        return objectArray;
    }

    record NormalSQLAndNamedParameterNameIndex(String normalSQL, String[] namedParameterNameIndex) {
    }
}

