/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql;

import cool.scx.data.jdbc.result_handler.ResultHandler;
import cool.scx.data.jdbc.sql.SQL;
import cool.scx.data.jdbc.sql.UpdateResult;
import cool.scx.functional.ScxConsumer;
import cool.scx.functional.ScxFunction;
import cool.scx.functional.ScxRunnable;
import cool.scx.util.ScxExceptionHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import javax.sql.DataSource;

public final class SQLRunner {
    private static final InheritableThreadLocal<Connection> CONNECTION_THREAD_LOCAL = new InheritableThreadLocal();
    private final DataSource dataSource;

    public SQLRunner(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        this.dataSource = dataSource;
    }

    public static <T> T query(Connection con, SQL sql, ResultHandler<T> resultHandler) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1003, 1007);){
            sql.fillParams(preparedStatement);
            resultHandler.beforeExecuteQuery(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            Object object = resultHandler.apply(resultSet);
            return (T)object;
        }
    }

    public static long execute(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            sql.fillParams(preparedStatement);
            preparedStatement.execute();
            long l = preparedStatement.getLargeUpdateCount();
            return l;
        }
    }

    public static UpdateResult update(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            sql.fillParams(preparedStatement);
            long affectedItemsCount = preparedStatement.executeLargeUpdate();
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public static UpdateResult updateBatch(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            sql.fillParams(preparedStatement);
            int affectedItemsCount = preparedStatement.executeLargeBatch().length;
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public static void autoTransaction(Connection con, ScxConsumer<Connection, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            handler.accept((Object)con);
            con.commit();
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    public static <T> T autoTransaction(Connection con, ScxFunction<Connection, T, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            Object result = handler.apply((Object)con);
            con.commit();
            return (T)result;
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    private static List<Long> getGeneratedKeys(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    public <T> T query(SQL sql, ResultHandler<T> resultHandler) {
        return (T)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.query(connection, sql, resultHandler);
            }
            try (Connection con = this.getConnection();){
                Object t = SQLRunner.query(con, sql, resultHandler);
                return t;
            }
        });
    }

    public long execute(SQL sql) {
        return (Long)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.execute(connection, sql);
            }
            try (Connection con = this.getConnection();){
                Long l = SQLRunner.execute(con, sql);
                return l;
            }
        });
    }

    public UpdateResult update(SQL sql) {
        return (UpdateResult)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.update(connection, sql);
            }
            try (Connection con = this.getConnection();){
                UpdateResult updateResult = SQLRunner.update(con, sql);
                return updateResult;
            }
        });
    }

    public UpdateResult updateBatch(SQL sql) {
        return (UpdateResult)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.updateBatch(connection, sql);
            }
            try (Connection con = this.getConnection();){
                UpdateResult updateResult = SQLRunner.updateBatch(con, sql);
                return updateResult;
            }
        });
    }

    public void autoTransaction(ScxRunnable<?> handler) {
        ScxExceptionHelper.wrap(() -> ((ForkJoinTask)ForkJoinPool.commonPool().submit(() -> {
            try (Connection con = this.getConnection(false);){
                CONNECTION_THREAD_LOCAL.set(con);
                try {
                    handler.run();
                    con.commit();
                    Object var3_3 = null;
                    return var3_3;
                }
                catch (Exception e) {
                    con.rollback();
                    throw e;
                }
                finally {
                    CONNECTION_THREAD_LOCAL.remove();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        })).get());
    }

    public <T> T autoTransaction(Callable<T> handler) {
        return (T)ScxExceptionHelper.wrap(() -> ((ForkJoinTask)ForkJoinPool.commonPool().submit(() -> {
            try (Connection con = this.getConnection(false);){
                CONNECTION_THREAD_LOCAL.set(con);
                try {
                    Object result = handler.call();
                    con.commit();
                    Object v = result;
                    return v;
                }
                catch (Exception e) {
                    con.rollback();
                    throw e;
                }
                finally {
                    CONNECTION_THREAD_LOCAL.remove();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        })).get());
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection con = this.dataSource.getConnection();
        con.setAutoCommit(autoCommit);
        return con;
    }
}

