/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.type_handler;

import cool.scx.data.jdbc.type_handler.TypeHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumTypeHandler<E extends Enum<E>>
implements TypeHandler<E> {
    private static final Logger logger = LoggerFactory.getLogger(EnumTypeHandler.class);
    private final Class<E> type;

    public EnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    @Override
    public void setObject(PreparedStatement ps, int i, E parameter) throws SQLException {
        ps.setString(i, ((Enum)parameter).name());
    }

    @Override
    public E getObject(ResultSet rs, int index) throws SQLException {
        String name = rs.getString(index);
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.type, name);
        }
        catch (Exception e) {
            logger.error("\u679a\u4e3e\u8f6c\u6362\u51fa\u73b0\u9519\u8bef : ", (Throwable)e);
            return null;
        }
    }
}

