/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.type_handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.scx.data.jdbc.type_handler.TypeHandler;
import cool.scx.util.ObjectUtils;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTypeHandler
implements TypeHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectTypeHandler.class);
    private static final ObjectMapper objectMapper = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE});
    private final JavaType javaType;

    public ObjectTypeHandler(Type type) {
        this.javaType = ObjectUtils.constructType((Type)type);
    }

    @Override
    public void setObject(PreparedStatement ps, int i, Object parameter) throws SQLException {
        try {
            String json = objectMapper.writeValueAsString(parameter);
            ps.setString(i, json);
        }
        catch (JsonProcessingException e) {
            logger.error("\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            ps.setNull(i, 0);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        String json = rs.getString(index);
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readValue(json, this.javaType);
        }
        catch (JsonProcessingException e) {
            logger.error("\u53cd\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            return null;
        }
    }
}

