/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.type_handler;

import cool.scx.data.jdbc.type_handler.BlobInputStreamTypeHandler;
import cool.scx.data.jdbc.type_handler.ByteArrayTypeHandler;
import cool.scx.data.jdbc.type_handler.ByteObjectArrayTypeHandler;
import cool.scx.data.jdbc.type_handler.ClobReaderTypeHandler;
import cool.scx.data.jdbc.type_handler.EnumTypeHandler;
import cool.scx.data.jdbc.type_handler.ObjectTypeHandler;
import cool.scx.data.jdbc.type_handler.StringTypeHandler;
import cool.scx.data.jdbc.type_handler.TypeHandler;
import cool.scx.data.jdbc.type_handler.math.BigDecimalTypeHandler;
import cool.scx.data.jdbc.type_handler.math.BigIntegerTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.BooleanTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.ByteTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.CharacterTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.DoubleTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.FloatTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.IntegerTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.LongTypeHandler;
import cool.scx.data.jdbc.type_handler.primitive.ShortTypeHandler;
import cool.scx.data.jdbc.type_handler.time.DateTypeHandler;
import cool.scx.data.jdbc.type_handler.time.DurationTypeHandler;
import cool.scx.data.jdbc.type_handler.time.InstantTypeHandler;
import cool.scx.data.jdbc.type_handler.time.LocalDateTimeTypeHandler;
import cool.scx.data.jdbc.type_handler.time.LocalDateTypeHandler;
import cool.scx.data.jdbc.type_handler.time.LocalTimeTypeHandler;
import cool.scx.data.jdbc.type_handler.time.MonthTypeHandler;
import cool.scx.data.jdbc.type_handler.time.OffsetDateTimeTypeHandler;
import cool.scx.data.jdbc.type_handler.time.OffsetTimeTypeHandler;
import cool.scx.data.jdbc.type_handler.time.YearMonthTypeHandler;
import cool.scx.data.jdbc.type_handler.time.YearTypeHandler;
import cool.scx.data.jdbc.type_handler.time.ZonedDateTimeTypeHandler;
import cool.scx.util.reflect.ClassUtils;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeHandlerSelector {
    private static final Map<Type, TypeHandler<?>> TYPE_HANDLER_MAP = new ConcurrentHashMap();

    public static <T> TypeHandler<T> findTypeHandler(Type type) {
        return TYPE_HANDLER_MAP.computeIfAbsent(type, TypeHandlerSelector::createTypeHandler);
    }

    private static <E extends Enum<E>> TypeHandler<?> createTypeHandler(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (ClassUtils.isEnum((Class)clazz)) {
                Class enumClass = clazz.isAnonymousClass() ? clazz.getSuperclass() : clazz;
                return new EnumTypeHandler(enumClass);
            }
            for (Map.Entry<Type, TypeHandler<?>> entry : TYPE_HANDLER_MAP.entrySet()) {
                Class c;
                Type type2 = entry.getKey();
                if (!(type2 instanceof Class) || !(c = (Class)type2).isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
        }
        return new ObjectTypeHandler(type);
    }

    static {
        TYPE_HANDLER_MAP.put(Boolean.TYPE, new BooleanTypeHandler(true));
        TYPE_HANDLER_MAP.put(Character.TYPE, new CharacterTypeHandler(true));
        TYPE_HANDLER_MAP.put(Byte.TYPE, new ByteTypeHandler(true));
        TYPE_HANDLER_MAP.put(Short.TYPE, new ShortTypeHandler(true));
        TYPE_HANDLER_MAP.put(Integer.TYPE, new IntegerTypeHandler(true));
        TYPE_HANDLER_MAP.put(Long.TYPE, new LongTypeHandler(true));
        TYPE_HANDLER_MAP.put(Float.TYPE, new FloatTypeHandler(true));
        TYPE_HANDLER_MAP.put(Double.TYPE, new DoubleTypeHandler(true));
        TYPE_HANDLER_MAP.put((Type)((Object)Boolean.class), new BooleanTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)Character.class), new CharacterTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)Byte.class), new ByteTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)Short.class), new ShortTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)Integer.class), new IntegerTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)Long.class), new LongTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)Float.class), new FloatTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)Double.class), new DoubleTypeHandler(false));
        TYPE_HANDLER_MAP.put((Type)((Object)String.class), new StringTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)Byte[].class), new ByteObjectArrayTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)byte[].class), new ByteArrayTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)BigInteger.class), new BigIntegerTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)BigDecimal.class), new BigDecimalTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)LocalDateTime.class), new LocalDateTimeTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)LocalDate.class), new LocalDateTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)LocalTime.class), new LocalTimeTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)OffsetDateTime.class), new OffsetDateTimeTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)OffsetTime.class), new OffsetTimeTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)ZonedDateTime.class), new ZonedDateTimeTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)Month.class), new MonthTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)Year.class), new YearTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)YearMonth.class), new YearMonthTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)Date.class), new DateTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)Instant.class), new InstantTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)Duration.class), new DurationTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)InputStream.class), new BlobInputStreamTypeHandler());
        TYPE_HANDLER_MAP.put((Type)((Object)Reader.class), new ClobReaderTypeHandler());
    }
}

