/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data;

import cool.scx.data.AnnotationConfigColumn;
import cool.scx.data.annotation.NoColumn;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.util.CaseUtils;
import cool.scx.util.MultiMap;
import cool.scx.util.StringUtils;
import cool.scx.util.reflect.FieldUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class AnnotationConfigTable
implements Table<AnnotationConfigColumn> {
    private final AnnotationConfigColumn[] columns;
    private final String name;
    private final Map<String, AnnotationConfigColumn> columnMap;

    public AnnotationConfigTable(Class<?> clazz) {
        this.name = AnnotationConfigTable.initTableName(clazz);
        this.columns = AnnotationConfigTable.initAllColumns(clazz);
        this.columnMap = AnnotationConfigTable.initAllColumnMap(this.columns);
    }

    public static String initTableName(Class<?> clazz) {
        cool.scx.data.annotation.Table scxModel = clazz.getAnnotation(cool.scx.data.annotation.Table.class);
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tableName())) {
            return scxModel.tableName();
        }
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tablePrefix())) {
            return scxModel.tablePrefix() + "_" + CaseUtils.toSnake((String)clazz.getSimpleName());
        }
        return "scx_" + CaseUtils.toSnake((String)clazz.getSimpleName());
    }

    private static AnnotationConfigColumn[] initAllColumns(Class<?> clazz) {
        List<AnnotationConfigColumn> list = Stream.of(FieldUtils.findFields(clazz)).filter(field -> !field.isAnnotationPresent(NoColumn.class)).map(AnnotationConfigColumn::new).toList();
        AnnotationConfigTable.checkDuplicateColumnName(list, clazz);
        return (AnnotationConfigColumn[])list.toArray(AnnotationConfigColumn[]::new);
    }

    private static Map<String, AnnotationConfigColumn> initAllColumnMap(AnnotationConfigColumn[] infos) {
        HashMap<String, AnnotationConfigColumn> map = new HashMap<String, AnnotationConfigColumn>();
        for (AnnotationConfigColumn info : infos) {
            map.put(info.name(), info);
        }
        for (AnnotationConfigColumn info : infos) {
            map.put(info.javaField().getName(), info);
        }
        return map;
    }

    private static void checkDuplicateColumnName(List<AnnotationConfigColumn> list, Class<?> clazz) {
        MultiMap multiMap = new MultiMap();
        for (AnnotationConfigColumn info : list) {
            multiMap.put((Object)info.name(), (Object)info);
        }
        Map map = multiMap.toMultiValueMap();
        for (Map.Entry entry : map.entrySet()) {
            List v = (List)entry.getValue();
            if (v.size() <= 1) continue;
            throw new IllegalArgumentException("\u91cd\u590d\u7684 columnName !!! Class -> " + clazz.getName() + ", Field -> " + v.stream().map(c -> c.javaField().getName()).toList());
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public AnnotationConfigColumn[] columns() {
        return this.columns;
    }

    @Override
    public AnnotationConfigColumn getColumn(String column) {
        return this.columnMap.get(column);
    }
}

