/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.jdbc.dialect.Dialect;
import cool.scx.data.jdbc.dialect.DialectSelector;
import cool.scx.data.jdbc.mapping.Column;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.data.jdbc.meta_data.MetaDataHelper;
import cool.scx.data.jdbc.meta_data.TableMetaData;
import cool.scx.data.jdbc.sql.SQL;
import cool.scx.data.jdbc.sql.SQLRunner;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public final class SchemaHelper {
    public static String getMigrateSQL(Table<?> oldTable, Table<?> newTable, Dialect dialect) {
        return "";
    }

    public static SchemaVerifyResult verify(Table<?> oldTable, Table<?> newTable) {
        Object column;
        ArrayList<Column> needAdd = new ArrayList<Column>();
        ArrayList<Column> needRemove = new ArrayList<Column>();
        ArrayList<Column> needChange = new ArrayList<Column>();
        for (Column oldColumn : oldTable.columns()) {
            column = newTable.getColumn(oldColumn.name());
            if (column != null) continue;
            needRemove.add(oldColumn);
        }
        for (Column newColumn : newTable.columns()) {
            column = oldTable.getColumn(newColumn.name());
            if (column != null) continue;
            needAdd.add(newColumn);
        }
        return new SchemaVerifyResult((Column[])needAdd.toArray(Column[]::new), needRemove, needChange);
    }

    public static void fixTable(Table<?> tableInfo, String databaseName, DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            Map<String, TableMetaData> map = MetaDataHelper.toTablesMap(MetaDataHelper.initTables(con.getMetaData(), databaseName, databaseName, tableInfo.name(), null));
            TableMetaData tableMetaData = map.get(tableInfo.name());
            if (tableMetaData == null) {
                String createTableDDL = DialectSelector.findDialect(dataSource).getCreateTableDDL(tableInfo);
                SQLRunner.execute(con, SQL.ofNormal(createTableDDL));
            } else {
                SchemaVerifyResult verify = SchemaHelper.verify(tableMetaData.refreshColumns(con.getMetaData()), tableInfo);
                Column[] needAdd = verify.needAdd();
                if (needAdd.length > 0) {
                    String alertTableDDL = DialectSelector.findDialect(dataSource).getAlertTableDDL(needAdd, tableInfo);
                    SQLRunner.execute(con, SQL.ofNormal(alertTableDDL));
                }
            }
        }
    }

    public static boolean checkNeedFixTable(Table<?> tableInfo, String databaseName, DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            Map<String, TableMetaData> map = MetaDataHelper.toTablesMap(MetaDataHelper.initTables(con.getMetaData(), databaseName, databaseName, tableInfo.name(), null));
            TableMetaData tableMetaData = map.get(tableInfo.name());
            if (tableMetaData == null) {
                boolean bl = true;
                return bl;
            }
            SchemaVerifyResult verify = SchemaHelper.verify(tableMetaData.refreshColumns(con.getMetaData()), tableInfo);
            Column[] needAdd = verify.needAdd();
            if (needAdd.length > 0) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public record SchemaVerifyResult(Column[] needAdd, List<Column> needRemove, List<Column> needChange) {
    }
}

