/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.bean_builder;

import cool.scx.data.jdbc.type_handler.TypeHandler;
import cool.scx.data.jdbc.type_handler.TypeHandlerSelector;
import cool.scx.util.reflect.FieldUtils;
import java.lang.reflect.Field;
import java.util.function.Function;

final class FieldSetter {
    private final Field javaField;
    private final String columnName;
    private final TypeHandler<?> typeHandler;

    public FieldSetter(Field field, String columnName) {
        this.javaField = field;
        this.columnName = columnName;
        this.javaField.setAccessible(true);
        this.typeHandler = TypeHandlerSelector.findTypeHandler(field.getGenericType());
    }

    static FieldSetter[] ofArray(Class<?> type, Function<Field, String> columnNameMapping) {
        Field[] fields = FieldUtils.findFields(type);
        FieldSetter[] fieldSetters = new FieldSetter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field;
            String columnName = columnNameMapping.apply(field = fields[i]);
            fieldSetters[i] = new FieldSetter(field, columnName != null ? columnName : field.getName());
        }
        return fieldSetters;
    }

    public String columnName() {
        return this.columnName;
    }

    public Field javaField() {
        return this.javaField;
    }

    public TypeHandler<?> typeHandler() {
        return this.typeHandler;
    }
}

