/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.meta_data;

import cool.scx.data.jdbc.mapping.Schema;
import cool.scx.data.jdbc.meta_data.MetaDataHelper;
import cool.scx.data.jdbc.meta_data.TableMetaData;
import java.sql.DatabaseMetaData;

public final class SchemaMetaData
implements Schema {
    private final String catalog;
    private final String name;
    private TableMetaData[] tables;

    public SchemaMetaData(String catalog, String name) {
        this.catalog = catalog;
        this.name = name;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String name() {
        return this.name;
    }

    public TableMetaData[] tables() {
        return this.tables;
    }

    public SchemaMetaData refreshTables(DatabaseMetaData dbMetaData) {
        return this.refreshTables(dbMetaData, false);
    }

    public SchemaMetaData refreshTables(DatabaseMetaData dbMetaData, boolean deep) {
        this.tables = MetaDataHelper.initTables(dbMetaData, this.catalog, this.name, null, null);
        if (deep) {
            for (TableMetaData table : this.tables) {
                table.refreshColumns(dbMetaData);
            }
        }
        return this;
    }
}

