/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import cool.scx.data.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.WhereTypeHandler;
import cool.scx.data.query.WhereBody;
import cool.scx.data.query.WhereType;
import cool.scx.data.query.parser.WhereClauseAndWhereParams;
import cool.scx.data.query.parser.WhereParser;

public class JDBCDaoWhereParser
extends WhereParser {
    private final AnnotationConfigTable tableInfo;

    public JDBCDaoWhereParser(AnnotationConfigTable tableInfo) {
        this.tableInfo = tableInfo;
    }

    private static WhereTypeHandler findWhereTypeHandler(WhereType whereType) {
        return switch (whereType) {
            default -> throw new IncompatibleClassChangeError();
            case WhereType.IS_NULL -> WhereTypeHandler.IS_NULL_HANDLER;
            case WhereType.IS_NOT_NULL -> WhereTypeHandler.IS_NOT_NULL_HANDLER;
            case WhereType.EQUAL -> WhereTypeHandler.EQUAL_HANDLER;
            case WhereType.NOT_EQUAL -> WhereTypeHandler.NOT_EQUAL_HANDLER;
            case WhereType.LESS_THAN -> WhereTypeHandler.LESS_THAN_HANDLER;
            case WhereType.LESS_THAN_OR_EQUAL -> WhereTypeHandler.LESS_THAN_OR_EQUAL_HANDLER;
            case WhereType.GREATER_THAN -> WhereTypeHandler.GREATER_THAN_HANDLER;
            case WhereType.GREATER_THAN_OR_EQUAL -> WhereTypeHandler.GREATER_THAN_OR_EQUAL_HANDLER;
            case WhereType.LIKE -> WhereTypeHandler.LIKE_HANDLER;
            case WhereType.NOT_LIKE -> WhereTypeHandler.NOT_LIKE_HANDLER;
            case WhereType.LIKE_REGEX -> WhereTypeHandler.LIKE_REGEX_HANDLER;
            case WhereType.NOT_LIKE_REGEX -> WhereTypeHandler.NOT_LIKE_REGEX_HANDLER;
            case WhereType.IN -> WhereTypeHandler.IN_HANDLER;
            case WhereType.NOT_IN -> WhereTypeHandler.NOT_IN_HANDLER;
            case WhereType.BETWEEN -> WhereTypeHandler.BETWEEN_HANDLER;
            case WhereType.NOT_BETWEEN -> WhereTypeHandler.NOT_BETWEEN_HANDLER;
            case WhereType.JSON_CONTAINS -> WhereTypeHandler.JSON_CONTAINS_HANDLER;
        };
    }

    @Override
    public WhereClauseAndWhereParams parseWhereBody(WhereBody body) {
        return JDBCDaoWhereParser.findWhereTypeHandler(body.whereType()).getWhereParamsAndWhereClause(this.tableInfo, body.name(), body.whereType(), body.value1(), body.value2(), body.info());
    }
}

