/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql;

import cool.scx.data.jdbc.dialect.Dialect;
import cool.scx.data.jdbc.mapping.Column;
import cool.scx.util.StringUtils;
import java.util.Arrays;

public final class SQLBuilder {
    private final SQLBuilderType sqlBuilderType;
    private String[] selectColumns = null;
    private String tableName = null;
    private String whereClause = null;
    private String[] groupByColumns = null;
    private String[] orderByClauses = null;
    private Long offset = null;
    private Long rowCount = null;
    private String[] insertColumns = null;
    private String[] insertValues = null;
    private String[] updateSetColumns = null;

    private SQLBuilder(SQLBuilderType sqlBuilderType) {
        this.sqlBuilderType = sqlBuilderType;
    }

    public static SQLBuilder Select(String ... selectColumns) {
        return new SQLBuilder(SQLBuilderType.SELECT)._Select(selectColumns);
    }

    public static SQLBuilder Insert(String tableName, String ... insertColumns) {
        return new SQLBuilder(SQLBuilderType.INSERT)._Insert(tableName, insertColumns);
    }

    public static SQLBuilder Insert(String tableName, Column ... insertColumnInfos) {
        return SQLBuilder.Insert(tableName, (String[])Arrays.stream(insertColumnInfos).map(Column::name).toArray(String[]::new));
    }

    public static SQLBuilder Update(String tableName) {
        return new SQLBuilder(SQLBuilderType.UPDATE)._Update(tableName);
    }

    public static SQLBuilder Delete(String tableName) {
        return new SQLBuilder(SQLBuilderType.DELETE)._Delete(tableName);
    }

    private SQLBuilder _Select(String ... selectColumns) {
        if (selectColumns.length == 0) {
            throw new IllegalArgumentException("Select \u5b50\u53e5\u9519\u8bef : \u5f85\u67e5\u8be2\u7684\u6570\u636e\u5217 \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        this.selectColumns = selectColumns;
        return this;
    }

    public SQLBuilder From(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SQLBuilder Where(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public SQLBuilder GroupBy(String ... groupByColumns) {
        this.groupByColumns = groupByColumns;
        return this;
    }

    public SQLBuilder OrderBy(String ... orderByClauses) {
        this.orderByClauses = orderByClauses;
        return this;
    }

    public SQLBuilder Limit(Long offset, Long rowCount) {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef : offset (\u504f\u79fb\u91cf) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        if (rowCount != null && rowCount < 0L) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef : rowCount (\u6bcf\u9875\u6570\u91cf) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.offset = offset;
        this.rowCount = rowCount;
        return this;
    }

    public SQLBuilder Limit(Long size) {
        return this.Limit(0L, size);
    }

    private SQLBuilder _Insert(String tableName, String ... insertColumns) {
        this.tableName = tableName;
        this.insertColumns = insertColumns;
        return this;
    }

    public SQLBuilder Values(String ... insertValues) {
        this.insertValues = insertValues;
        return this;
    }

    private SQLBuilder _Update(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SQLBuilder Set(String ... updateSetColumns) {
        if (updateSetColumns.length == 0) {
            throw new IllegalArgumentException("Set \u5b50\u53e5\u9519\u8bef : \u5f85\u66f4\u65b0\u7684\u6570\u636e\u5217 \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        this.updateSetColumns = updateSetColumns;
        return this;
    }

    public SQLBuilder _Delete(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String GetSQL(Dialect dialect) {
        return switch (this.sqlBuilderType) {
            default -> throw new IncompatibleClassChangeError();
            case SQLBuilderType.INSERT -> this.GetInsertSQL();
            case SQLBuilderType.UPDATE -> this.GetUpdateSQL();
            case SQLBuilderType.DELETE -> this.GetDeleteSQL();
            case SQLBuilderType.SELECT -> this.GetSelectSQL(dialect);
        };
    }

    private String GetInsertSQL() {
        return "INSERT INTO " + this.tableName + " (" + String.join((CharSequence)", ", this.insertColumns) + ") VALUES (" + String.join((CharSequence)", ", this.insertValues) + ")";
    }

    private String GetUpdateSQL() {
        return "UPDATE " + this.tableName + " SET " + String.join((CharSequence)", ", this.updateSetColumns) + this.getWhereClause();
    }

    private String GetDeleteSQL() {
        return "DELETE FROM " + this.tableName + this.getWhereClause();
    }

    private String GetSelectSQL(Dialect dialect) {
        String sql = "SELECT " + String.join((CharSequence)", ", this.selectColumns) + " FROM " + this.tableName + this.getWhereClause() + this.getGroupByClause() + this.getOrderByClause();
        return dialect.getLimitSQL(sql, this.offset, this.rowCount);
    }

    private String getWhereClause() {
        return StringUtils.notEmpty((String)this.whereClause) ? " WHERE " + this.whereClause : "";
    }

    private String getGroupByClause() {
        return this.groupByColumns != null && this.groupByColumns.length != 0 ? " GROUP BY " + String.join((CharSequence)", ", this.groupByColumns) : "";
    }

    private String getOrderByClause() {
        return this.orderByClauses != null && this.orderByClauses.length != 0 ? " ORDER BY " + String.join((CharSequence)", ", this.orderByClauses) : "";
    }

    static enum SQLBuilderType {
        INSERT,
        DELETE,
        UPDATE,
        SELECT;

    }
}

