/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.type_handler.time;

import cool.scx.data.jdbc.type_handler.TypeHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateTimeTypeHandler
implements TypeHandler<LocalDateTime> {
    private static final Logger logger = LoggerFactory.getLogger(LocalDateTimeTypeHandler.class);

    @Override
    public LocalDateTime getObject(ResultSet rs, int index) throws SQLException {
        try {
            return rs.getObject(index, LocalDateTime.class);
        }
        catch (SQLFeatureNotSupportedException e) {
            logger.warn("\u5f53\u524d\u9a71\u52a8\u4e0d\u652f\u6301 LocalDateTime, \u5c1d\u8bd5\u4f7f\u7528 String \u8fdb\u884c\u8f6c\u6362 !!!", (Throwable)e);
            String str = rs.getString(index);
            if (str != null) {
                try {
                    return LocalDateTime.parse(str);
                }
                catch (DateTimeParseException de) {
                    logger.warn("\u5f53\u524d\u9a71\u52a8\u4e0d\u652f\u6301 LocalDateTime, \u5c1d\u8bd5\u4f7f\u7528 String \u8fdb\u884c\u8f6c\u6362\u5931\u8d25 !!!", (Throwable)e);
                }
            }
            return null;
        }
    }
}

