/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.parser;

import cool.scx.data.query.AND;
import cool.scx.data.query.Logic;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereBody;
import cool.scx.data.query.parser.WhereClauseAndWhereParams;
import java.util.ArrayList;
import java.util.List;

public abstract class WhereParser {
    public final WhereClauseAndWhereParams parseAll(Object[] objs) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object obj : objs) {
            WhereClauseAndWhereParams w = this.parse(obj);
            if (w == null) continue;
            whereClause.append(w.whereClause());
            whereParams.addAll(List.of(w.whereParams()));
        }
        return new WhereClauseAndWhereParams(whereClause.toString(), whereParams.toArray());
    }

    public WhereClauseAndWhereParams parse(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return this.parseString(str);
        }
        if (obj instanceof WhereBody) {
            WhereBody whereBody = (WhereBody)obj;
            return this.parseWhereBody(whereBody);
        }
        if (obj instanceof Logic) {
            Logic l = (Logic)obj;
            return this.parseLogic(l);
        }
        return null;
    }

    public final WhereClauseAndWhereParams parseString(String str) {
        return new WhereClauseAndWhereParams(str, new Object[0]);
    }

    public final WhereClauseAndWhereParams parseLogic(Logic l) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object c : l.clauses()) {
            WhereClauseAndWhereParams w = this.parse(c);
            if (w == null) continue;
            clauses.add(w.whereClause());
            whereParams.addAll(List.of(w.whereParams()));
        }
        Object clause = String.join((CharSequence)(" " + l.keyWord() + " "), clauses);
        if (clauses.size() > 1) {
            clause = "(" + (String)clause + ")";
        }
        return new WhereClauseAndWhereParams((String)clause, whereParams.toArray());
    }

    public final WhereClauseAndWhereParams parseWhere(Where where) {
        WhereClauseAndWhereParams w1 = this.parse(new AND(where.whereBodyList().toArray()));
        WhereClauseAndWhereParams w2 = this.parseAll(where.whereSQL());
        return w1.concat(w2);
    }

    public abstract WhereClauseAndWhereParams parseWhereBody(WhereBody var1);
}

