/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.OrderByBody;
import cool.scx.data.query.OrderByOption;
import cool.scx.data.query.OrderByType;
import java.util.ArrayList;
import java.util.List;

public final class OrderBy {
    private final List<OrderByBody> orderByBodyList;

    public OrderBy() {
        this.orderByBodyList = new ArrayList<OrderByBody>();
    }

    public OrderBy(OrderBy oldOrderBy) {
        this.orderByBodyList = new ArrayList<OrderByBody>(oldOrderBy.orderByBodyList);
    }

    public OrderBy add(String name, OrderByType orderByType, OrderByOption ... options) {
        OrderByOption.Info info = new OrderByOption.Info(options);
        OrderByBody orderByBody = new OrderByBody(name, orderByType, info);
        if (info.replace()) {
            this.orderByBodyList.removeIf(w -> orderByBody.name().equals(w.name()));
        }
        this.orderByBodyList.add(orderByBody);
        return this;
    }

    public OrderBy asc(String name, OrderByOption ... options) {
        return this.add(name, OrderByType.ASC, options);
    }

    public OrderBy desc(String name, OrderByOption ... options) {
        return this.add(name, OrderByType.DESC, options);
    }

    public OrderBy remove(String name) {
        this.orderByBodyList.removeIf(w -> w.name().equals(name.trim()));
        return this;
    }

    public OrderBy clear() {
        this.orderByBodyList.clear();
        return this;
    }

    public List<OrderByBody> orderByBodyList() {
        return this.orderByBodyList;
    }
}

