/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.parser;

import cool.scx.data.query.Logic;
import cool.scx.data.query.LogicType;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereBody;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import cool.scx.data.query.parser.WhereClauseAndWhereParams;
import java.util.ArrayList;
import java.util.List;

public abstract class WhereParser {
    public final WhereClauseAndWhereParams parseAll(Object[] objs) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object obj : objs) {
            WhereClauseAndWhereParams w = this.parse(obj);
            if (w == null) continue;
            whereClause.append(w.whereClause());
            whereParams.addAll(List.of(w.whereParams()));
        }
        return new WhereClauseAndWhereParams(whereClause.toString(), whereParams.toArray());
    }

    public WhereClauseAndWhereParams parse(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return this.parseString(str);
        }
        if (obj instanceof WhereBody) {
            WhereBody whereBody = (WhereBody)obj;
            return this.parseWhereBody(whereBody);
        }
        if (obj instanceof Logic) {
            Logic l = (Logic)obj;
            return this.parseLogic(l);
        }
        return null;
    }

    public final WhereClauseAndWhereParams parseString(String str) {
        return new WhereClauseAndWhereParams(str, new Object[0]);
    }

    public final WhereClauseAndWhereParams parseLogic(Logic l) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object c : l.clauses()) {
            WhereClauseAndWhereParams w = this.parse(c);
            if (w == null) continue;
            clauses.add(w.whereClause());
            whereParams.addAll(List.of(w.whereParams()));
        }
        Object clause = String.join((CharSequence)(" " + this.getLogicKeyWord(l.type()) + " "), clauses);
        if (clauses.size() > 1) {
            clause = "(" + (String)clause + ")";
        }
        return new WhereClauseAndWhereParams((String)clause, whereParams.toArray());
    }

    public final WhereClauseAndWhereParams parseWhere(Where where) {
        return this.parseAll(where.whereBodyList());
    }

    public WhereClauseAndWhereParams parseWhereBody(WhereBody body) {
        String name = body.name();
        WhereType whereType = body.whereType();
        Object value1 = body.value1();
        Object value2 = body.value2();
        WhereOption.Info info = body.info();
        return switch (whereType) {
            default -> throw new IncompatibleClassChangeError();
            case WhereType.IS_NULL, WhereType.IS_NOT_NULL -> this.parseIsNull(name, whereType, value1, value2, info);
            case WhereType.EQUAL, WhereType.NOT_EQUAL, WhereType.LESS_THAN, WhereType.LESS_THAN_OR_EQUAL, WhereType.GREATER_THAN, WhereType.GREATER_THAN_OR_EQUAL, WhereType.LIKE_REGEX, WhereType.NOT_LIKE_REGEX -> this.parseEqual(name, whereType, value1, value2, info);
            case WhereType.LIKE, WhereType.NOT_LIKE -> this.parseLike(name, whereType, value1, value2, info);
            case WhereType.IN, WhereType.NOT_IN -> this.parseIn(name, whereType, value1, value2, info);
            case WhereType.BETWEEN, WhereType.NOT_BETWEEN -> this.parseBetween(name, whereType, value1, value2, info);
            case WhereType.JSON_CONTAINS -> this.parseJsonContains(name, whereType, value1, value2, info);
        };
    }

    public abstract WhereClauseAndWhereParams parseJsonContains(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClauseAndWhereParams parseBetween(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClauseAndWhereParams parseIn(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClauseAndWhereParams parseLike(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClauseAndWhereParams parseEqual(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClauseAndWhereParams parseIsNull(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public String getLogicKeyWord(LogicType logicType) {
        return switch (logicType) {
            default -> throw new IncompatibleClassChangeError();
            case LogicType.OR -> "OR";
            case LogicType.AND -> "AND";
        };
    }

    public String getWhereKeyWord(WhereType whereType) {
        return switch (whereType) {
            default -> throw new IncompatibleClassChangeError();
            case WhereType.IS_NULL -> "IS NULL";
            case WhereType.IS_NOT_NULL -> "IS NOT NULL";
            case WhereType.EQUAL -> "=";
            case WhereType.NOT_EQUAL -> "<>";
            case WhereType.LESS_THAN -> "<";
            case WhereType.LESS_THAN_OR_EQUAL -> "<=";
            case WhereType.GREATER_THAN -> ">";
            case WhereType.GREATER_THAN_OR_EQUAL -> ">=";
            case WhereType.LIKE_REGEX, WhereType.LIKE -> "LIKE";
            case WhereType.NOT_LIKE_REGEX, WhereType.NOT_LIKE -> "NOT LIKE";
            case WhereType.IN -> "IN";
            case WhereType.NOT_IN -> "NOT IN";
            case WhereType.BETWEEN -> "BETWEEN";
            case WhereType.NOT_BETWEEN -> "NOT BETWEEN";
            case WhereType.JSON_CONTAINS -> "JSON_CONTAINS";
        };
    }
}

