/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data;

import cool.scx.data.query.GroupBy;
import cool.scx.data.query.Limit;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByBody;
import cool.scx.data.query.Where;

public class Query {
    private final Where where;
    private final GroupBy groupBy;
    private final OrderBy orderBy;
    private final Limit limit;

    public Query() {
        this.where = new Where();
        this.groupBy = new GroupBy();
        this.orderBy = new OrderBy();
        this.limit = new Limit();
    }

    public Query(Query oldQuery) {
        this.where = new Where(oldQuery.where);
        this.groupBy = new GroupBy(oldQuery.groupBy);
        this.orderBy = new OrderBy(oldQuery.orderBy);
        this.limit = new Limit(oldQuery.limit);
    }

    public Query where(Object ... whereClauses) {
        this.where.set(whereClauses);
        return this;
    }

    public Query groupBy(Object ... groupByClauses) {
        this.groupBy.set(groupByClauses);
        return this;
    }

    public Query orderBy(OrderByBody ... orderByClauses) {
        this.orderBy.set(orderByClauses);
        return this;
    }

    public Query offset(long limitOffset) {
        this.limit.offset(limitOffset);
        return this;
    }

    public Query limit(long numberOfRows) {
        this.limit.limit(numberOfRows);
        return this;
    }

    public Where getWhere() {
        return this.where;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public Query clearWhere() {
        this.where.clear();
        return this;
    }

    public Query clearGroupBy() {
        this.groupBy.clear();
        return this;
    }

    public Query clearOrderBy() {
        this.orderBy.clear();
        return this;
    }

    public Query clearOffset() {
        this.limit.clearOffset();
        return this;
    }

    public Query clearLimit() {
        this.limit.clearLimit();
        return this;
    }
}

