/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.parser;

import cool.scx.data.query.Logic;
import cool.scx.data.query.LogicType;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereBody;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import java.util.ArrayList;
import java.util.List;

public abstract class WhereParser {
    public final WhereClause parseAll(Object[] objs) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object obj : objs) {
            WhereClause w = this.parse(obj);
            if (w == null || w.isEmpty()) continue;
            whereClause.append(w.whereClause());
            whereParams.addAll(List.of(w.params()));
        }
        return new WhereClause(whereClause.toString(), whereParams.toArray());
    }

    public WhereClause parse(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return this.parseString(str);
        }
        if (obj instanceof WhereBody) {
            WhereBody whereBody = (WhereBody)obj;
            return this.parseWhereBody(whereBody);
        }
        if (obj instanceof Logic) {
            Logic l = (Logic)obj;
            return this.parseLogic(l);
        }
        if (obj instanceof WhereClause) {
            WhereClause w = (WhereClause)obj;
            return w;
        }
        return null;
    }

    public final WhereClause parseString(String str) {
        return new WhereClause(str, new Object[0]);
    }

    public final WhereClause parseLogic(Logic l) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object c : l.clauses()) {
            WhereClause w = this.parse(c);
            if (w == null || w.isEmpty()) continue;
            clauses.add(w.whereClause());
            whereParams.addAll(List.of(w.params()));
        }
        Object clause = String.join((CharSequence)(" " + this.getLogicKeyWord(l.type()) + " "), clauses);
        if (clauses.size() > 1) {
            clause = "(" + (String)clause + ")";
        }
        return new WhereClause((String)clause, whereParams.toArray());
    }

    public final WhereClause parseWhere(Where where) {
        return this.parseAll(where.clauses());
    }

    public WhereClause parseWhereBody(WhereBody body) {
        String name = body.name();
        WhereType whereType = body.whereType();
        Object value1 = body.value1();
        Object value2 = body.value2();
        WhereOption.Info info = body.info();
        return switch (whereType) {
            default -> throw new IncompatibleClassChangeError();
            case WhereType.IS_NULL, WhereType.IS_NOT_NULL -> this.parseIsNull(name, whereType, value1, value2, info);
            case WhereType.EQUAL, WhereType.NOT_EQUAL, WhereType.LESS_THAN, WhereType.LESS_THAN_OR_EQUAL, WhereType.GREATER_THAN, WhereType.GREATER_THAN_OR_EQUAL, WhereType.LIKE_REGEX, WhereType.NOT_LIKE_REGEX -> this.parseEqual(name, whereType, value1, value2, info);
            case WhereType.LIKE, WhereType.NOT_LIKE -> this.parseLike(name, whereType, value1, value2, info);
            case WhereType.IN, WhereType.NOT_IN -> this.parseIn(name, whereType, value1, value2, info);
            case WhereType.BETWEEN, WhereType.NOT_BETWEEN -> this.parseBetween(name, whereType, value1, value2, info);
            case WhereType.JSON_CONTAINS -> this.parseJsonContains(name, whereType, value1, value2, info);
        };
    }

    public abstract WhereClause parseJsonContains(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClause parseBetween(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClause parseIn(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClause parseLike(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClause parseEqual(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public abstract WhereClause parseIsNull(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    public String getLogicKeyWord(LogicType logicType) {
        return switch (logicType) {
            default -> throw new IncompatibleClassChangeError();
            case LogicType.OR -> "OR";
            case LogicType.AND -> "AND";
        };
    }

    public String getWhereKeyWord(WhereType whereType) {
        return switch (whereType) {
            default -> throw new IncompatibleClassChangeError();
            case WhereType.IS_NULL -> "IS NULL";
            case WhereType.IS_NOT_NULL -> "IS NOT NULL";
            case WhereType.EQUAL -> "=";
            case WhereType.NOT_EQUAL -> "<>";
            case WhereType.LESS_THAN -> "<";
            case WhereType.LESS_THAN_OR_EQUAL -> "<=";
            case WhereType.GREATER_THAN -> ">";
            case WhereType.GREATER_THAN_OR_EQUAL -> ">=";
            case WhereType.LIKE_REGEX, WhereType.LIKE -> "LIKE";
            case WhereType.NOT_LIKE_REGEX, WhereType.NOT_LIKE -> "NOT LIKE";
            case WhereType.IN -> "IN";
            case WhereType.NOT_IN -> "NOT IN";
            case WhereType.BETWEEN -> "BETWEEN";
            case WhereType.NOT_BETWEEN -> "NOT BETWEEN";
            case WhereType.JSON_CONTAINS -> "JSON_CONTAINS";
        };
    }
}

