/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data;

import cool.scx.data.field_filter.FilterMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FieldFilter {
    private final Set<String> fieldNames = new HashSet<String>();
    private final FilterMode filterMode;
    private boolean excludeIfFieldValueIsNull;

    private FieldFilter(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.excludeIfFieldValueIsNull = true;
    }

    public static FieldFilter ofIncluded(String ... fieldNames) {
        return new FieldFilter(FilterMode.INCLUDED).addIncluded(fieldNames);
    }

    public static FieldFilter ofExcluded(String ... fieldNames) {
        return new FieldFilter(FilterMode.EXCLUDED).addExcluded(fieldNames);
    }

    private FieldFilter _addFieldNames(String ... fieldNames) {
        Collections.addAll(this.fieldNames, fieldNames);
        return this;
    }

    private FieldFilter _removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this;
    }

    public FieldFilter addIncluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.INCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public FieldFilter addExcluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.EXCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public FieldFilter removeIncluded(String ... fieldNames) {
        return this.addExcluded(fieldNames);
    }

    public FieldFilter removeExcluded(String ... fieldNames) {
        return this.addIncluded(fieldNames);
    }

    public FieldFilter clear() {
        this.fieldNames.clear();
        return this;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public boolean getExcludeIfFieldValueIsNull() {
        return this.excludeIfFieldValueIsNull;
    }

    public FieldFilter excludeIfFieldValueIsNull(boolean excludeIfFieldValueIsNull) {
        this.excludeIfFieldValueIsNull = excludeIfFieldValueIsNull;
        return this;
    }
}

