/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.Logic;
import cool.scx.data.query.LogicType;
import cool.scx.data.query.WhereBody;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import cool.scx.data.query.exception.ValidParamListIsEmptyException;
import cool.scx.data.query.exception.WrongWhereTypeParamSizeException;
import java.util.ArrayList;
import java.util.List;

public final class WhereBodySet
implements Logic {
    private final List<WhereBody> whereBodyList;
    private final LogicType type;

    public WhereBodySet(LogicType type) {
        this.type = type;
        this.whereBodyList = new ArrayList<WhereBody>();
    }

    public WhereBodySet add2(String name, WhereType whereType, Object value1, Object value2, WhereOption ... options) {
        return this._add(name, whereType, value1, value2, 2, options);
    }

    public WhereBodySet add1(String name, WhereType whereType, Object value1, WhereOption ... options) {
        return this._add(name, whereType, value1, null, 1, options);
    }

    public WhereBodySet add0(String name, WhereType whereType, WhereOption ... options) {
        return this._add(name, whereType, null, null, 0, options);
    }

    public boolean isEmpty() {
        return this.whereBodyList.size() == 0;
    }

    public WhereBodySet isNull(String fieldName, WhereOption ... options) {
        return this.add0(fieldName, WhereType.IS_NULL, options);
    }

    public WhereBodySet isNotNull(String fieldName, WhereOption ... options) {
        return this.add0(fieldName, WhereType.IS_NOT_NULL, options);
    }

    public WhereBodySet equal(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.EQUAL, value, options);
    }

    public WhereBodySet notEqual(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_EQUAL, value, options);
    }

    public WhereBodySet greaterThan(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.GREATER_THAN, value, options);
    }

    public WhereBodySet greaterThanOrEqual(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.GREATER_THAN_OR_EQUAL, value, options);
    }

    public WhereBodySet lessThan(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LESS_THAN, value, options);
    }

    public WhereBodySet lessThanOrEqual(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LESS_THAN_OR_EQUAL, value, options);
    }

    public WhereBodySet between(String fieldName, Object value1, Object value2, WhereOption ... options) {
        return this.add2(fieldName, WhereType.BETWEEN, value1, value2, options);
    }

    public WhereBodySet notBetween(String fieldName, Object value1, Object value2, WhereOption ... options) {
        return this.add2(fieldName, WhereType.NOT_BETWEEN, value1, value2, options);
    }

    public WhereBodySet likeRegex(String fieldName, String value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LIKE_REGEX, value, options);
    }

    public WhereBodySet notLikeRegex(String fieldName, String value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_LIKE_REGEX, value, options);
    }

    public WhereBodySet like(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LIKE, value, options);
    }

    public WhereBodySet notLike(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_LIKE, value, options);
    }

    public WhereBodySet jsonContains(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.JSON_CONTAINS, value, options);
    }

    public WhereBodySet in(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.IN, value, options);
    }

    public WhereBodySet notIn(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_IN, value, options);
    }

    private WhereBodySet _add(String name, WhereType whereType, Object value1, Object value2, int needParamSize, WhereOption ... options) {
        block6: {
            WhereOption.Info info = new WhereOption.Info(options);
            try {
                WhereBody whereBody = new WhereBody(name, whereType, value1, value2, info);
                if (whereType.paramSize() != needParamSize) {
                    throw new IllegalArgumentException("Where \u53c2\u6570\u9519\u8bef : whereType \u7c7b\u578b : " + whereType + " , \u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a " + whereType.paramSize());
                }
                if (info.replace()) {
                    this.whereBodyList.removeIf(w -> whereBody.name().equals(w.name()));
                }
                this.whereBodyList.add(whereBody);
            }
            catch (WrongWhereTypeParamSizeException e) {
                if (!info.skipIfNull()) {
                    throw e;
                }
            }
            catch (ValidParamListIsEmptyException e) {
                if (info.skipIfEmptyList()) break block6;
                throw e;
            }
        }
        return this;
    }

    public WhereBodySet remove(String name) {
        this.whereBodyList.removeIf(w -> w.name().equals(name.trim()));
        return this;
    }

    public WhereBodySet clear() {
        this.whereBodyList.clear();
        return this;
    }

    @Override
    public LogicType type() {
        return this.type;
    }

    @Override
    public Object[] clauses() {
        return this.whereBodyList.toArray();
    }
}

