/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data;

import cool.scx.data.Query;
import cool.scx.data.query.GroupBy;
import cool.scx.data.query.LimitInfo;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.Where;

public class QueryImpl
implements Query {
    private final Where where;
    private final GroupBy groupBy;
    private final OrderBy orderBy;
    private final LimitInfo limitInfo;

    public QueryImpl() {
        this.where = new Where();
        this.groupBy = new GroupBy();
        this.orderBy = new OrderBy();
        this.limitInfo = new LimitInfo();
    }

    public QueryImpl(Query oldQuery) {
        this.where = new Where(oldQuery.getWhere());
        this.groupBy = new GroupBy(oldQuery.getGroupBy());
        this.orderBy = new OrderBy(oldQuery.getOrderBy());
        this.limitInfo = new LimitInfo(oldQuery.getLimitInfo());
    }

    public QueryImpl where(Object ... whereClauses) {
        this.where.set(whereClauses);
        return this;
    }

    public QueryImpl groupBy(Object ... groupByClauses) {
        this.groupBy.set(groupByClauses);
        return this;
    }

    public QueryImpl orderBy(Object ... orderByClauses) {
        this.orderBy.set(orderByClauses);
        return this;
    }

    public QueryImpl offset(long limitOffset) {
        this.limitInfo.offset(limitOffset);
        return this;
    }

    public QueryImpl limit(long numberOfRows) {
        this.limitInfo.limit(numberOfRows);
        return this;
    }

    @Override
    public Where getWhere() {
        return this.where;
    }

    @Override
    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public Long getOffset() {
        return this.limitInfo.getOffset();
    }

    @Override
    public Long getLimit() {
        return this.limitInfo.getLimit();
    }

    @Override
    public LimitInfo getLimitInfo() {
        return this.limitInfo;
    }

    public QueryImpl clearWhere() {
        this.where.clear();
        return this;
    }

    public QueryImpl clearGroupBy() {
        this.groupBy.clear();
        return this;
    }

    public QueryImpl clearOrderBy() {
        this.orderBy.clear();
        return this;
    }

    public QueryImpl clearOffset() {
        this.limitInfo.clearOffset();
        return this;
    }

    public QueryImpl clearLimit() {
        this.limitInfo.clearLimit();
        return this;
    }
}

