/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.parser;

import cool.scx.data.Query;
import cool.scx.data.query.GroupBy;
import cool.scx.data.query.GroupByBody;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public abstract class GroupByParser {
    public final String[] parseGroupBy(GroupBy groupBy) {
        String[] all = this.parseAll(groupBy.clauses());
        return (String[])Arrays.stream(all).distinct().toArray(String[]::new);
    }

    public final String[] parseAll(Object[] objs) {
        ArrayList list = new ArrayList();
        for (Object obj : objs) {
            String[] s = this.parse(obj);
            Collections.addAll(list, s);
        }
        return (String[])list.toArray(String[]::new);
    }

    public String[] parse(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return new String[]{this.parseString(str)};
        }
        if (obj instanceof GroupByBody) {
            GroupByBody groupByBody = (GroupByBody)obj;
            return new String[]{this.parseGroupByBody(groupByBody)};
        }
        if (obj instanceof Query) {
            Query q = (Query)obj;
            return this.parseAll(q.getGroupBy().clauses());
        }
        return null;
    }

    private String parseString(String str) {
        return str;
    }

    public abstract String parseGroupByBody(GroupByBody var1);
}

