/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.Query;
import cool.scx.data.query.GroupBy;
import cool.scx.data.query.LimitInfo;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.Where;

public class QueryImpl
implements Query {
    private final Where where;
    private final GroupBy groupBy;
    private final OrderBy orderBy;
    private final LimitInfo limitInfo;

    public QueryImpl() {
        this.where = new Where();
        this.groupBy = new GroupBy();
        this.orderBy = new OrderBy();
        this.limitInfo = new LimitInfo();
    }

    public QueryImpl(Query oldQuery) {
        this.where = new Where(oldQuery.getWhere());
        this.groupBy = new GroupBy(oldQuery.getGroupBy());
        this.orderBy = new OrderBy(oldQuery.getOrderBy());
        this.limitInfo = new LimitInfo(oldQuery.getLimitInfo());
    }

    QueryImpl(Where oldWhere) {
        this(oldWhere, new GroupBy(), new OrderBy(), new LimitInfo());
    }

    QueryImpl(GroupBy oldGroupBy) {
        this(new Where(), oldGroupBy, new OrderBy(), new LimitInfo());
    }

    QueryImpl(OrderBy oldOrderBy) {
        this(new Where(), new GroupBy(), oldOrderBy, new LimitInfo());
    }

    QueryImpl(LimitInfo oldLimitInfo) {
        this(new Where(), new GroupBy(), new OrderBy(), oldLimitInfo);
    }

    private QueryImpl(Where oldWhere, GroupBy oldGroupBy, OrderBy oldOrderBy, LimitInfo oldLimitInfo) {
        this.where = oldWhere;
        this.groupBy = oldGroupBy;
        this.orderBy = oldOrderBy;
        this.limitInfo = oldLimitInfo;
    }

    @Override
    public QueryImpl where(Object ... whereClauses) {
        this.where.set(whereClauses);
        return this;
    }

    @Override
    public QueryImpl groupBy(Object ... groupByClauses) {
        this.groupBy.set(groupByClauses);
        return this;
    }

    @Override
    public QueryImpl orderBy(Object ... orderByClauses) {
        this.orderBy.set(orderByClauses);
        return this;
    }

    @Override
    public QueryImpl addWhere(Object ... whereClauses) {
        this.where.add(whereClauses);
        return this;
    }

    @Override
    public QueryImpl addGroupBy(Object ... groupByClauses) {
        this.groupBy.add(groupByClauses);
        return this;
    }

    @Override
    public QueryImpl addOrderBy(Object ... orderByClauses) {
        this.orderBy.add(orderByClauses);
        return this;
    }

    @Override
    public QueryImpl offset(long limitOffset) {
        this.limitInfo.offset(limitOffset);
        return this;
    }

    @Override
    public QueryImpl limit(long numberOfRows) {
        this.limitInfo.limit(numberOfRows);
        return this;
    }

    @Override
    public Where getWhere() {
        return this.where;
    }

    @Override
    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public Long getOffset() {
        return this.limitInfo.getOffset();
    }

    @Override
    public Long getLimit() {
        return this.limitInfo.getLimit();
    }

    @Override
    public LimitInfo getLimitInfo() {
        return this.limitInfo;
    }

    @Override
    public QueryImpl clearWhere() {
        this.where.clear();
        return this;
    }

    @Override
    public QueryImpl clearGroupBy() {
        this.groupBy.clear();
        return this;
    }

    @Override
    public QueryImpl clearOrderBy() {
        this.orderBy.clear();
        return this;
    }

    @Override
    public QueryImpl clearOffset() {
        this.limitInfo.clearOffset();
        return this;
    }

    @Override
    public QueryImpl clearLimit() {
        this.limitInfo.clearLimit();
        return this;
    }
}

