/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.deserializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.data.query.GroupBy;
import cool.scx.data.query.GroupByBody;
import cool.scx.data.query.GroupByOption;
import java.util.ArrayList;

public class GroupByDeserializer {
    public Object deserialize(JsonNode v) {
        if (v.isObject()) {
            String type;
            return switch (type = v.get("@type").asText()) {
                case "GroupBy" -> this.deserializeGroupBy(v);
                case "GroupByBody" -> this.deserializeGroupByBody(v);
                default -> null;
            };
        }
        if (v.isTextual()) {
            return this.deserializeString(v);
        }
        if (v.isArray()) {
            return this.deserializeAll(v);
        }
        return null;
    }

    public GroupBy deserializeGroupBy(JsonNode v) {
        if (v == null) {
            return new GroupBy();
        }
        GroupBy groupBy = new GroupBy();
        groupBy.set(this.deserializeAll(v.get("clauses")));
        return groupBy;
    }

    public GroupByBody deserializeGroupByBody(JsonNode v) {
        String name = v.path("name").asText();
        return new GroupByBody(name, new GroupByOption.Info(new GroupByOption[0]));
    }

    private String deserializeString(JsonNode v) {
        return v.textValue();
    }

    private Object[] deserializeAll(JsonNode v) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (JsonNode jsonNode : v) {
            s.add(this.deserialize(jsonNode));
        }
        return s.toArray();
    }
}

