/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.deserializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByBody;
import cool.scx.data.query.OrderByBodySet;
import cool.scx.data.query.OrderByOption;
import cool.scx.data.query.OrderByType;
import java.util.ArrayList;

public class OrderByDeserializer {
    public Object deserialize(JsonNode v) {
        if (v.isObject()) {
            String type;
            return switch (type = v.get("@type").asText()) {
                case "OrderBy" -> this.deserializeOrderBy(v);
                case "OrderByBodySet" -> this.deserializeOrderByBodySet(v);
                case "OrderByBody" -> this.deserializeOrderByBody(v);
                default -> null;
            };
        }
        if (v.isTextual()) {
            return this.deserializeString(v);
        }
        if (v.isArray()) {
            return this.deserializeAll(v);
        }
        return null;
    }

    public OrderBy deserializeOrderBy(JsonNode v) {
        if (v == null) {
            return new OrderBy();
        }
        OrderBy orderBy = new OrderBy();
        orderBy.set(this.deserializeAll(v.get("clauses")));
        return orderBy;
    }

    public OrderByBodySet deserializeOrderByBodySet(JsonNode v) {
        Object[] clauses;
        OrderByBodySet orderByBodySet = new OrderByBodySet();
        for (Object clause : clauses = this.deserializeAll(v.get("clauses"))) {
            if (!(clause instanceof OrderByBody)) continue;
            OrderByBody b = (OrderByBody)clause;
            orderByBodySet.add(b.name(), b.orderByType(), new OrderByOption[0]);
        }
        return orderByBodySet;
    }

    public OrderByBody deserializeOrderByBody(JsonNode v) {
        String name = v.path("name").asText();
        OrderByType orderByType = OrderByType.of(v.path("orderByType").asText());
        return new OrderByBody(name, orderByType, new OrderByOption.Info(new OrderByOption[0]));
    }

    private String deserializeString(JsonNode v) {
        return v.textValue();
    }

    private Object[] deserializeAll(JsonNode v) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (JsonNode jsonNode : v) {
            s.add(this.deserialize(jsonNode));
        }
        return s.toArray();
    }
}

