/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.deserializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.Query;
import cool.scx.data.query.GroupBy;
import cool.scx.data.query.LimitInfo;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.Where;
import cool.scx.data.query.deserializer.GroupByDeserializer;
import cool.scx.data.query.deserializer.LimitInfoDeserializer;
import cool.scx.data.query.deserializer.OrderByDeserializer;
import cool.scx.data.query.deserializer.WhereDeserializer;

public class QueryDeserializer {
    public static final QueryDeserializer QUERY_DESERIALIZER = new QueryDeserializer();
    private final WhereDeserializer whereDeserializer = new WhereDeserializer();
    private final GroupByDeserializer groupByDeserializer = new GroupByDeserializer();
    private final OrderByDeserializer orderByDeserializer = new OrderByDeserializer();
    private final LimitInfoDeserializer limitInfoDeserializer = new LimitInfoDeserializer();

    public Query fromJson(String json) throws JsonProcessingException {
        JsonNode v = ObjectUtils.jsonMapper().readTree(json);
        return this.deserializeAny(v);
    }

    public Query deserializeAny(JsonNode v) {
        Object deserialize = this.deserialize(v);
        if (deserialize == null) {
            deserialize = this.whereDeserializer.deserialize(v);
        }
        if (deserialize == null) {
            deserialize = this.groupByDeserializer.deserialize(v);
        }
        if (deserialize == null) {
            deserialize = this.orderByDeserializer.deserialize(v);
        }
        if (deserialize == null) {
            deserialize = this.limitInfoDeserializer.deserialize(v);
        }
        return (Query)deserialize;
    }

    public Object deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("Query")) {
            return this.deserializeQuery(v);
        }
        return null;
    }

    public Query deserializeQuery(JsonNode objectNode) {
        if (objectNode == null) {
            return new QueryImpl();
        }
        Where where = this.whereDeserializer.deserializeWhere(objectNode.get("where"));
        GroupBy groupBy = this.groupByDeserializer.deserializeGroupBy(objectNode.get("groupBy"));
        OrderBy orderBy = this.orderByDeserializer.deserializeOrderBy(objectNode.get("orderBy"));
        LimitInfo limitInfo = this.limitInfoDeserializer.deserializeLimitInfo(objectNode.get("limitInfo"));
        return new QueryImpl(where, groupBy, orderBy, limitInfo);
    }
}

