/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.deserializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.AND;
import cool.scx.data.query.Logic;
import cool.scx.data.query.OR;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereBody;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import java.util.ArrayList;

public class WhereDeserializer {
    public Object deserialize(JsonNode v) {
        if (v.isObject()) {
            String type;
            return switch (type = v.get("@type").asText()) {
                case "Where" -> this.deserializeWhere(v);
                case "Logic" -> this.deserializeLogic(v);
                case "WhereClause" -> this.deserializeWhereClause(v);
                case "WhereBody" -> this.deserializeWhereBody(v);
                default -> null;
            };
        }
        if (v.isTextual()) {
            return this.deserializeString(v);
        }
        if (v.isArray()) {
            return this.deserializeAll(v);
        }
        return null;
    }

    public Where deserializeWhere(JsonNode v) {
        if (v == null) {
            return new Where();
        }
        Where where = new Where();
        where.set(this.deserializeAll(v.get("clauses")));
        return where;
    }

    private Logic deserializeLogic(JsonNode v) {
        String logicType = v.get("logicType").asText();
        if (logicType.equals("OR")) {
            return new OR(this.deserializeAll(v.get("clauses")));
        }
        if (logicType.equals("AND")) {
            return new AND(this.deserializeAll(v.get("clauses")));
        }
        return null;
    }

    private WhereClause deserializeWhereClause(JsonNode v) {
        String whereClause = v.get("whereClause").asText();
        Object[] params = (Object[])ObjectUtils.convertValue((Object)v.get("params"), Object[].class);
        return new WhereClause(whereClause, params);
    }

    private WhereBody deserializeWhereBody(JsonNode v) {
        String name = v.get("name").asText();
        WhereType whereType = WhereType.of(v.get("whereType").asText());
        Object value1 = ObjectUtils.convertValue((Object)v.get("value1"), Object.class);
        Object value2 = ObjectUtils.convertValue((Object)v.get("value2"), Object.class);
        return new WhereBody(name, whereType, value1, value2, new WhereOption[0]);
    }

    private String deserializeString(JsonNode v) {
        return v.textValue();
    }

    private Object[] deserializeAll(JsonNode v) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (JsonNode jsonNode : v) {
            s.add(this.deserialize(jsonNode));
        }
        return s.toArray();
    }
}

