/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.Query;
import cool.scx.data.query.serializer.GroupBySerializer;
import cool.scx.data.query.serializer.LimitInfoSerializer;
import cool.scx.data.query.serializer.OrderBySerializer;
import cool.scx.data.query.serializer.WhereSerializer;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;

public class QuerySerializer {
    public static final QuerySerializer QUERY_SERIALIZER = new QuerySerializer();
    private final WhereSerializer whereSerializer = new WhereSerializer();
    private final GroupBySerializer groupBySerializer = new GroupBySerializer();
    private final OrderBySerializer orderBySerializer = new OrderBySerializer();
    private final LimitInfoSerializer limitInfoSerializer = new LimitInfoSerializer();

    public String toJson(Query query) throws JsonProcessingException {
        Object v = this.serializeAny(query);
        return ObjectUtils.jsonMapper().writeValueAsString(v);
    }

    public Object serializeAny(Object object) {
        Object serialize = this.serialize(object);
        if (serialize == null) {
            serialize = this.whereSerializer.serialize(object);
        }
        if (serialize == null) {
            serialize = this.groupBySerializer.serialize(object);
        }
        if (serialize == null) {
            serialize = this.orderBySerializer.serialize(object);
        }
        if (serialize == null) {
            serialize = this.limitInfoSerializer.serialize(object);
        }
        return serialize;
    }

    public Object serialize(Object obj) {
        Object object = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Query.class}, (Object)object, n)) {
            case 0 -> {
                Query s = (Query)object;
                yield this.serializeQueryImpl(s);
            }
            default -> null;
        };
    }

    public LinkedHashMap<String, Object> serializeQueryImpl(Query query) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Query");
        m.put("where", this.whereSerializer.serialize(query.getWhere()));
        m.put("groupBy", this.groupBySerializer.serialize(query.getGroupBy()));
        m.put("orderBy", this.orderBySerializer.serialize(query.getOrderBy()));
        m.put("limitInfo", this.limitInfoSerializer.serialize(query.getLimitInfo()));
        return m;
    }
}

