package cool.scx.data.query.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;

import java.util.ArrayList;

import static cool.scx.common.util.ObjectUtils.convertValue;

public class OrderByDeserializer {

    public Object deserialize(JsonNode v) {
        if (v.isObject()) {
            var type = v.get("@type").asText();
            return switch (type) {
                case "OrderBy" -> deserializeOrderBy(v);
                default -> v;
            };
        } else if (v.isTextual()) {
            return deserializeString(v);
        } else if (v.isArray()) {
            return deserializeAll(v);
        }
        return null;
    }

    private OrderBy deserializeOrderBy(JsonNode v) {
        var name = v.path("name").asText();
        var orderByType = convertValue(v.path("orderByType"), OrderByType.class);
        return new OrderBy(name, orderByType);
    }

    private String deserializeString(JsonNode v) {
        return v.textValue();
    }

    private Object[] deserializeAll(JsonNode v) {
        var s = new ArrayList<>();
        for (var jsonNode : v) {
            s.add(deserialize(jsonNode));
        }
        return s.toArray();
    }

}
