/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueryImpl
implements Query {
    private final List<Object> where = new ArrayList<Object>();
    private final List<Object> groupBy = new ArrayList<Object>();
    private final List<Object> orderBy = new ArrayList<Object>();
    private Long offset = null;
    private Long limit = null;

    public QueryImpl() {
    }

    public QueryImpl(Query oldQuery) {
        this();
        this.addWhere(oldQuery.getWhere());
        this.addGroupBy(oldQuery.getGroupBy());
        this.addOrderBy(oldQuery.getOrderBy());
        if (oldQuery.getOffset() != null) {
            this.offset(oldQuery.getOffset());
        }
        if (oldQuery.getLimit() != null) {
            this.limit(oldQuery.getLimit());
        }
    }

    @Override
    public QueryImpl where(Object ... whereClauses) {
        this.clearWhere();
        this.addWhere(whereClauses);
        return this;
    }

    @Override
    public QueryImpl groupBy(Object ... groupByClauses) {
        this.clearGroupBy();
        this.addGroupBy(groupByClauses);
        return this;
    }

    @Override
    public QueryImpl orderBy(Object ... orderByClauses) {
        this.clearOrderBy();
        this.addOrderBy(orderByClauses);
        return this;
    }

    @Override
    public QueryImpl offset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Limit \u53c2\u6570\u9519\u8bef : offset (\u504f\u79fb\u91cf) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.offset = offset;
        return this;
    }

    @Override
    public QueryImpl limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit \u53c2\u6570\u9519\u8bef : limit (\u884c\u957f\u5ea6) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.limit = limit;
        return this;
    }

    @Override
    public QueryImpl addWhere(Object ... whereClauses) {
        Collections.addAll(this.where, whereClauses);
        return this;
    }

    @Override
    public QueryImpl addGroupBy(Object ... groupByClauses) {
        Collections.addAll(this.groupBy, groupByClauses);
        return this;
    }

    @Override
    public QueryImpl addOrderBy(Object ... orderByClauses) {
        Collections.addAll(this.orderBy, orderByClauses);
        return this;
    }

    @Override
    public Object[] getWhere() {
        return this.where.toArray();
    }

    @Override
    public Object[] getGroupBy() {
        return this.groupBy.toArray();
    }

    @Override
    public Object[] getOrderBy() {
        return this.orderBy.toArray();
    }

    @Override
    public Long getOffset() {
        return this.offset;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    @Override
    public QueryImpl clearWhere() {
        this.where.clear();
        return this;
    }

    @Override
    public QueryImpl clearGroupBy() {
        this.groupBy.clear();
        return this;
    }

    @Override
    public QueryImpl clearOrderBy() {
        this.orderBy.clear();
        return this;
    }

    @Override
    public QueryImpl clearOffset() {
        this.offset = null;
        return this;
    }

    @Override
    public QueryImpl clearLimit() {
        this.limit = null;
        return this;
    }
}

